% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_io.R
\name{read.md.demographics}
\alias{read.md.demographics}
\title{Read demographics file}
\usage{
read.md.demographics(
  demographics_file,
  column_names = NULL,
  header = FALSE,
  scale_and_center = FALSE,
  sep = "",
  report = FALSE,
  stringsAsFactors = TRUE,
  group_column_name = NULL
)
}
\arguments{
\item{demographics_file, }{string. The path to the file.}

\item{column_names, }{vector of strings. The column names to set in the returned dataframe. The length must match the number of columns in the file.}

\item{header, }{logical. Whether the file starts with a header line.}

\item{scale_and_center, }{logical. Whether to center and scale the data. Defaults to FALSE.}

\item{sep, }{string. Separator passed to \code{\link[utils]{read.table}}, defaults to tabulator.}

\item{report, }{logical. Whether to write an overview, i.e., some descriptive statistics for each column, to STDOUT. Defaults to FALSE. See \code{\link[fsbrain]{report.on.demographics}}.}

\item{stringsAsFactors, }{logical. Whether to convert strings in the input data to factors. Defaults to TRUE.}

\item{group_column_name, }{string or NULL. If given, the column name of the group column. It must be a factor column with 2 levels. Enables group-comparison tests. Defaults to NULL.}
}
\value{
a dataframe. The data in the file. String columns will be returned as factors, which you may want to adapt afterwards for the subject identifier column.
}
\description{
Load a list of subjects and metadata from a demographics file, i.e., a tab-separated file containing an arbitrary number of columns, one of which must be the subject id.
}
\examples{
   demographics_file =
   system.file("extdata", "demographics.tsv", package = "fsbrain", mustWork = TRUE);
   column_names = c("subject_id", "group", "age");
   demographics = read.md.demographics(demographics_file,
   header = TRUE, column_names = column_names, report = FALSE);

}
\seealso{
Other metadata functions: 
\code{\link{demographics.to.fsgd.file}()},
\code{\link{read.md.subjects}()},
\code{\link{report.on.demographics}()}
}
\concept{metadata functions}
