% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corfwdplot.R
\name{corfwdplot}
\alias{corfwdplot}
\title{Monitoring the correlations between consecutive distances or residuals}
\usage{
corfwdplot(out, trace = FALSE, ...)
}
\arguments{
\item{out}{An object of S3 class returned by one of the estimation functions with the
 monitoring option selected (\code{monitoring=TRUE}):
 \code{\link{fsreda.object}}, \code{\link{sregeda.object}}, \code{\link{mmregeda.object}}
 \code{\link{fsmeda.object}}, \code{\link{smulteda.object}} or \code{\link{mmmulteda.object}}.
 This is a list containing the monitoring of minimum Mahalanobis distance in case of
 multivariate analysis or the monitoring of residuals in case of regression.

 The needed elements of \code{out} are
   \enumerate{
       \item \code{MAL}: matrix containing the squared Mahalanobis distances monitored in each
         step of the forward search. Every row is associated with a unit (row of data matrix Y).
         This matrix can be created using one of the functions \code{\link{fsmult}},
         \code{\link{smult}} or \code{\link{mmmult}} with the monitoring option selected, i.e. \code{monitoring=TRUE}.
       \item \code{RES}: matrix containing the residuals monitored in each
         step of the forward search. Every row is associated with a unit (row of data matrix Y).
         This matrix can be created using the function \code{\link{fsreg}}  with
         the monitoring option selected, i.e. \code{monitoring=TRUE} .
       \item \code{bdp}: a vector containing breakdown point values that have been used, in case of S estimates.
       \item \code{eff}: a vector containing efficiency values that have been used, in case of MM estimates.
  }}

\item{trace}{Whether to print intermediate results. Default is \code{trace=FALSE}.}

\item{...}{potential further arguments passed to lower level functions.}
}
\value{
A \code{ggplot} plot object which can be printed on screen or to a file.
}
\description{
Provides a method for obtaining the maximum empirical efficiency
 (in case of MM estimates) or maximum empirical breakdownplot (in case of S estimates) or
 maximum subset size (in case of forward search),
 using various measures of correlation between the \code{n} Mahalanobis distances or residuals at
 adjacent values of efficiecy, breakdown point or subset size.
}
\examples{
 \dontrun{

 data(hbk)
 (out <- fsmult(hbk[,1:3], monitoring=TRUE))
 corfwdplot(out)

 }

}
\author{
FSDA team, \email{valentin.todorov@chello.at}
}
