% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslsmooth_in_mask.R
\name{fslsmooth_in_mask}
\alias{fslsmooth_in_mask}
\alias{fsl_smooth_in_mask}
\title{Smooth Image Within a Mask Only}
\usage{
fslsmooth_in_mask(file, sigma = 10, mask = NULL, ...)

fsl_smooth_in_mask(...)
}
\arguments{
\item{file}{(character) image to be smoothed}

\item{sigma}{(numeric) sigma (in mm) of Gaussian kernel for smoothing}

\item{mask}{(character) optional mask given for image}

\item{...}{additional arguments passed to \code{\link{fslsmooth}}.}
}
\value{
Object of class \code{nifti}
}
\description{
This function smooth an image within a mask and replaces the values of the
original image with the smoothed values.
}
\examples{
if (have.fsl()){
system.time({
dims = c(50, 50, 20)
x = array(rnorm(prod(dims)), dim = dims)
img = nifti(x, dim= dims, 
datatype = convert.datatype()$FLOAT32, cal.min = min(x), 
cal.max = max(x), pixdim = rep(1, 4))
mask = abs(img ) > 1
s.img = fslsmooth_in_mask(img, mask = mask)
})
}
}
