% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpectedValueAA.R
\name{ExpectedValueAA}
\alias{ExpectedValueAA}
\title{Expected Value for each Amino Acid}
\usage{
ExpectedValueAA(seqs, k = 2, normalized = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{k}{is an integer value. The default is two.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is 20^k.
}
\description{
This function is introduced by this package for the first time.
It computes the expected value for each k-mer in a sequence.
ExpectedValue(k-mer) = freq(k-mer) / (c_1 * c_2  * ... * c_k),
where c_i is the number of codons that encrypt the i'th amino acid in the k-mer.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat<-ExpectedValueAA(seqs=filePrs,k=2,normalized=FALSE)
}
