% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAAC.R
\name{SAAC}
\alias{SAAC}
\title{Splitted Amino Acid Composition(SAAC)}
\usage{
SAAC(seqs, k = 1, numNterm = 5, numCterm = 5, normalized = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{k}{shows which type of amino acid composition applies to the parts.
For example, the amino acid composition is applied when k=1 and when k=2, the dipeptide Composition is applied.}

\item{numNterm}{shows how many amino acids should be considered for N-terminal.}

\item{numCterm}{shows how many amino acids should be considered for C-terminal.}

\item{normalized}{is a logical parameter. When it is FALSE, the return value of the function does not change. Otherwise, the return value is normalized using the length of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
It returns a feature matrix. The number of rows is equal to the number of sequences.
The number of columns is (3*(20^k)).
}
\description{
This function splits the input sequence into three parts. The first part is N-terminal
and the third part is C-terminal and middle part contains all amino acids between these two part.
N-terminal will be determined by the first numNterm amino acid in the sequences and C-terminal is
determined by numCterm of the last amino acids in the sequence. Users should enter numNterm and numCterm
parameters. Their default value is 25.
The function calculates \link{kAAComposition} for each of the three parts.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat<-SAAC(seqs=filePrs,k=1,numNterm=15,numCterm=15)
}
