% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctionsStandard.R
\name{plot,fgpm-method}
\alias{plot,fgpm-method}
\title{Plot method for the class \code{"fgpm"}}
\usage{
\S4method{plot}{fgpm}(x, y = NULL, ...)
}
\arguments{
\item{x}{A \code{fgpm} object.}

\item{y}{Not used.}

\item{...}{Graphical parameters. These currently include
\itemize{
   \item{\code{xlim}, \code{ylim}}{ to set the limits of the axes.}
   \item{\code{pch}, \code{pt.col}, \code{pt.bg}, \code{pt.cex}}{ to set
       the symbol used for the points and the related properties.}
   \item{\code{line}}{ to set the color used for the line.}
   \item{\code{xlab}, \code{ylab}, \code{main}}{ to set
       the labels of the axes and the main title.} See
       \bold{Examples}.
}}
}
\description{
This method provides a diagnostic plot for the
    validation of regression models. It displays a calibration plot
    based on the leave-one-out predictions of the output at the
    points used to train the model.
}
\details{
Plot the Leave-One-Out (LOO) calibration.
}
\examples{
# generating input and output data for training
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0,1,length = sqrt(n.tr)),
                   x2 = seq(0, 1, length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10),
            f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)

# building the model
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# plotting the model
plot(m1)
# change some graphical parameters if wanted
plot(m1, line = "SpringGreen3" ,
     pch = 21, pt.col = "orangered", pt.bg = "gold",
     main = "LOO cross-validation")

}
