% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalues.R
\name{permut_pval}
\alias{permut_pval}
\title{Permutation-based computation of p-values}
\usage{
permut_pval(MatX, MatY, n_perm = 100, stat = c("mo", "med"), verbose = FALSE)
}
\arguments{
\item{MatX}{numeric matrix of dimension \verb{n_point x n} containing \code{n}
trajectories (in columns) of size \code{n_point} (in rows).}

\item{MatY}{numeric matrix of dimension \verb{n_point x m} containing \code{m}
trajectories (in columns) of size \code{n_point} (in rows).}

\item{n_perm}{integer, number of permutation to compute the p-values.}

\item{stat}{character string or vector of character string, name of the
statistics for which the p-values will be computed, among \code{"mo"}, \code{"med"},
\code{"wmw"}, \code{"hkr"}, \code{"cff"}.}

\item{verbose}{boolean, if TRUE, enable verbosity.}
}
\value{
list of named numeric value corresponding to the p-values for each
statistic listed in the \code{stat} input.
}
\description{
Computation of the p-values associated to any statistics
described in the package with the permutation methods. See Smida et al
(2022) for more details.
}
\examples{
# simulate small data for the example
simu_data <- simul_data(
    n_point = 20, n_obs1 = 4, n_obs2 = 5, c_val = 10, 
    delta_shape = "constant", distrib = "normal"
)

MatX <- simu_data$mat_sample1
MatY <- simu_data$mat_sample2
res <- permut_pval(
    MatX, MatY, n_perm = 100, stat = c("mo", "med", "wmw", "hkr", "cff"), 
    verbose = TRUE)
res
}
\references{
Zaineb Smida, Lionel Cucala, Ali Gannoun & Ghislain Durif (2022)
A median test for functional data, Journal of Nonparametric Statistics,
34:2, 520-553,
\doi{10.1080/10485252.2022.2064997},
\href{https://hal.science/hal-03658578}{hal-03658578}
}
\seealso{
\code{\link[=stat_mo]{stat_mo()}}, \code{\link[=stat_med]{stat_med()}},
\code{\link[=stat_wmw]{stat_wmw()}}, \code{\link[=stat_hkr]{stat_hkr()}},
\code{\link[=stat_cff]{stat_cff()}}, \code{\link[=comp_stat]{comp_stat()}}
}
