% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{stat_hkr}
\alias{stat_hkr}
\title{Horváth-Kokoszka-Reeder statistics}
\usage{
stat_hkr(MatX, MatY)
}
\arguments{
\item{MatX}{numeric matrix of dimension \verb{n_point x n} containing \code{n}
trajectories (in columns) of size \code{n_point} (in rows).}

\item{MatY}{numeric matrix of dimension \verb{n_point x m} containing \code{m}
trajectories (in columns) of size \code{n_point} (in rows).}
}
\value{
A list with the following elements
\itemize{
\item \code{T1}: numeric value corresponding to the HKR1 statistic value
\item \code{T2}: numeric value corresponding to the HKR2 statistic value
\item \code{eigenval}: numeric vector of eigen values from the empirical
pooled covariance matrix of \code{MatX} and \code{MatY} (see Smida et al, 2022, for
more details)
}
}
\description{
The Horváth-Kokoszka-Reeder statistics defined in
Chakraborty & Chaudhuri (2015) (and noted HKR1 and HKR2 in Smida et al 2022)
are computed to compare two sets of functional trajectories.
}
\examples{
simu_data <- simul_data(
    n_point = 100, n_obs1 = 50, n_obs2 = 75, c_val = 10, 
    delta_shape = "constant", distrib = "normal"
)

MatX <- simu_data$mat_sample1
MatY <- simu_data$mat_sample2

stat_hkr(MatX, MatY)
}
\references{
Horváth, L., Kokoszka, P., & Reeder, R. (2013). Estimation of the mean of
functional time series and a two-sample problem. Journal of the Royal
Statistical Society. Series B (Statistical Methodology), 75(1), 103–122.
\doi{10.1111/j.1467-9868.2012.01032.x}

Zaineb Smida, Lionel Cucala, Ali Gannoun & Ghislain Durif (2022)
A median test for functional data, Journal of Nonparametric Statistics,
34:2, 520-553,
\doi{10.1080/10485252.2022.2064997},
\href{https://hal.science/hal-03658578}{hal-03658578}
}
\seealso{
\code{\link[=comp_stat]{comp_stat()}}, \code{\link[=permut_pval]{permut_pval()}}
}
