% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{plot_bifd}
\alias{plot_bifd}
\title{Plot a Bivariate Functional Data Object.}
\usage{
plot_bifd(bifd_obj)
}
\arguments{
\item{bifd_obj}{A bivariate functional data object of class bifd,
containing one single replication.}
}
\value{
A ggplot with a geom_tile layer providing a plot of the
bivariate functional data object as a heat map.
}
\description{
Plot an object of class \code{bifd} using
\code{ggplot2} and \code{geom_tile}.
The object must contain only one single functional replication.
}
\examples{
library(funcharts)
mfdobj <- data_sim_mfd(nobs = 1)
tp <- tensor_product_mfd(mfdobj)
plot_bifd(tp)

}
