% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM.R
\name{FRTM_PhaseI}
\alias{FRTM_PhaseI}
\title{Phase I of the FRTM method.}
\usage{
FRTM_PhaseI(
  data_tra,
  data_tun = NULL,
  alpha = 0.05,
  n_basis_xall = 30,
  control.FDTW = list(),
  control.mFPCA = list(),
  control.rtr = list(),
  ncores = 1,
  print = TRUE
)
}
\arguments{
\item{data_tra}{A list containing the following arguments: \code{x_err} a list containing the discrete observations for each curve of the training set; \code{grid_i} a list of vector of time points where the curves of the training set are sampled.}

\item{data_tun}{A list containing the following arguments: \code{grid_i} a list containing the discrete observations for each curve of the tuning set;
\code{grid_i} a list of vector of time points where the curves of the tuning set are sampled. If NULL, the tuning set is not used.}

\item{alpha}{Overall type I error probability to obtain the  control chart limits.}

\item{n_basis_xall}{Number of basis to obtain the functional observation via  the spline smoothing approach based on cubic B-splines and a roughness penalty on the second derivative.}

\item{control.FDTW}{A list of  control parameters for the  open-end/open-begin functional dynamic time warping to replace defaults returned by par.FDTW. Values not set assume default values.}

\item{control.mFPCA}{A list of  control parameters for the   mixed functional principal component analysis to replace defaults returned by par.mFPCA. Values not set assume default values.}

\item{control.rtr}{A list of  control parameters for the  real-time registration step to replace defaults returned by par.rtr. Values not set assume default values.}

\item{ncores}{If \code{ncores}>1, then parallel computing is used, with \code{ncores} cores. Default is 1.}

\item{print}{If TRUE, some information are printed. Default is TRUE.}
}
\value{
A list containing the following arguments:

\code{T2_fd} List of \eqn{T^{2}} functions for each observation in the tuning set.

\code{SPE_fd} List of SPE functions for each observation in the tuning set.

\code{CL_T2} Control limit of  the Hotelling's \eqn{T^{2}} control chart.

\code{CL_SPE} Control limit of  the SPE control chart.

\code{template_fd} Template function used in the registration.

\code{der_template_fd} First derivative of the template function.

\code{u_fd} Upper extreme of the  band constraint.

\code{l_fd} Lower extreme of the  band constraint.

\code{x_list_tun} List, for each observation in the tuning set, of partial registered functions.

\code{h_list_tun} List, for each observation in the tuning set, of partial  warping  functions.

\code{x_list} List, for each observation in the training set, of partial registered functions.

\code{h_list} List, for each observation in the training set, of partial  warping  functions.

\code{x_err} A list containing the discrete observations for each curve of the training set.

\code{grid_i} A list of vector of time points where the curves of the training set are sampled.

\code{x_list_smooth} Smooth curves from the training set.

\code{lambda} Lambda identified through the average curve distance to obtain the OEB-FDTW solution.

\code{par_reg} Additional parameters to be used in the monitoring phase (Phase II).
}
\description{
This function implements the design phase (Phase I) of FRTM method.
}
\examples{
library(funcharts)
data <- simulate_data_FRTM(n_obs = 20)

data_oc <-
  simulate_data_FRTM(
    n_obs = 2,
    scenario = "1",
    shift = "OC_h",
    severity = 0.5
  )

lambda <- 10 ^ -5
max_x <- max(unlist(data$grid_i))
seq_t_tot <- seq(0, 1, length.out = 30)[-1]
seq_x <- seq(0.1, max_x, length.out = 10)


\dontrun{
  mod_phaseI_FRTM <- FRTM_PhaseI(
    data_tra =  data,
    control.FDTW = list(
      M = 30,
      N = 30,
      lambda = lambda,
      seq_t = seq_t_tot,
      iter_tem = 1,
      iter = 1
    ),
    control.rtr = list(seq_x = seq_x)
  )
  mod_phaseII_FRTM <- FRTM_PhaseII(data_oc = data_oc , mod_phaseI = mod_phaseI_FRTM)

  plot(mod_phaseI_FRTM)
  plot(mod_phaseII_FRTM)
}

}
\references{
Centofanti, F., A. Lepore, M. Kulahci, and M. P. Spooner (2024).
Real-time monitoring of functional data.
Accepted for publication in \emph{Journal of Quality Technology}.
}
\seealso{
\code{\link{FRTM_PhaseI}}
}
\author{
F. Centofanti
}
