% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating_loo.R
\name{amean_bymot_LOO}
\alias{amean_bymot_LOO}
\title{Arithmetic mean
by assembly motif
using leave-one-out method}
\usage{
amean_bymot_LOO(fobs)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are computed as the arithmetic mean of performances,
by excluding the assemblage to predict.
}
\description{
Take a vector \code{fobs} of assembly performances
and return a vector of performances
predicted as the arithmetic mean
of performances of all assemblages. \cr

All assemblages share the same assembly motif.
}
\details{
Predicted performances are computed using arithmetic mean
  (\code{opt.mean = "amean"}) of performances of assemblages
  that share a same assembly motif (\code{opt.model = "bymot"})
  by excluding the assemblage to predict.
}
\seealso{
\code{\link{amean_byelt_LOO}} arithmetic mean
  by elements occurring within assembly motif \cr
\code{\link{gmean_bymot_LOO}} geometric mean by assembly motif \cr
\code{\link{gmean_byelt_LOO}} geometric mean
  by elements occurring within assembly motif \cr
}
\keyword{internal}
