% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{fboot}
\alias{fboot}
\title{Evaluate the robustness of a functional clustering
 by bootstrapping from 1 to (all-1) observations}
\usage{
fboot(fres,
      opt.var = c("assemblages", "performances"), nbIter = 1,
      opt.nbMax = fres$nbOpt, opt.R2 = FALSE, opt.plot = FALSE,
      filename = "" )
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained using the function \code{\link{fclust}}.}

\item{opt.var}{a string, that indicates the variable to test.
The option can be \code{"assemblages"} or \code{"performances"}.}

\item{nbIter}{an integer, that indicates the number of random drawing to do.}

\item{opt.nbMax}{a logical. If \code{opt.plot = TRUE},
the trees resulting from leaving out each performance is plotted.}

\item{opt.R2}{a logical. If \code{opt.R2 = TRUE},
the primary tree is validated
and the vectors of coefficient of determination (\code{R^2})
and efficiency (\code{E}) are computed.}

\item{opt.plot}{a logical. If \code{opt.plot = TRUE},
the primary trees resulting from leaving out each performance are plotted.
If \code{opt.R2 = TRUE},
the secondary trees resulting from leaving out each performance are plotted.}

\item{filename}{a string, used as radical for naming the file
\code{"filename.components.csv"}, \code{"filemane.assemblages.csv"}
or \code{"filemane.performances.csv"}
according to the dimensions of matrices.}
}
\value{
a list of lists, each containing a matrix by clustering index.
}
\description{
Evaluate by bootstrapping
the robustness of a functional clustering
to perturbations of data. The perturbed data can be
the number of assemblages taken into account,
or the number of performances taken into account.
}
\details{
The trees obtained by bootstrapping of performances to omit
 are compared to the reference tree obtained with all components
 using different criteria :
 "Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" and "Sokal_Sneath2" index.
 For more informations, see the notice of R-package \code{clusterCrit}.
}
\examples{

# Enable the comments
oldOption <- getOption("verbose")
if (!oldOption) options(verbose = TRUE)
layout(matrix(c(1,2,3,4), nrow = 2, ncol = 2, byrow = TRUE))

\dontshow{
nbIter <- 1
fboot(fres = CedarCreek.2004.2006.res,
      opt.var   = "performances",
      nbIter    = nbIter,
      opt.nbMax = 1)
}

\donttest{
test.boot <- fboot(fres = CedarCreek.2004.2006.res,
                   opt.var  = "performances",
                   nbIter   = 4,
                   opt.plot = TRUE)
}

layout(1)
options(verbose = oldOption)

}
\references{
Package "clusterCrit": Clustering Indices,
  by Bernard Desgraupes (University of Paris Ouest - Lab Modal'X)
}
