% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating_loo.R
\name{validate_gmean_bymot_LOO}
\alias{validate_gmean_bymot_LOO}
\title{Predicting the performances
by assembly motif
using leave-one-out method}
\usage{
validate_gmean_bymot_LOO(fobs, assMotif)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{assMotif}{a vector of labels of \code{length(fobs)}.
The vector \code{assMotif} contains the assembly motifs of assemblages.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are computed as the geometric mean of performances
of assemblages that share a same assembly motif.
}
\description{
Take a vector \code{fobs} of assembly performances
and return a vector of performances
predicted as the geometric mean
of performances of all assemblages
that share a same assembly motif,
by excluding the assemblage to predict.
}
\details{
Predicted performances are computed
using geometric mean (\code{opt.mean = "gmean"})
of performances of assemblages
that share a same assembly motif (\code{opt.model = "bymot"})
by excluding the assemblage to predict.
}
\seealso{
\code{\link{validate_amean_bymot_LOO}} arithmetic mean
  by assembly motif \cr
\code{\link{validate_amean_byelt_LOO}} arithmetic mean
  by elements occurring within assembly motif \cr
\code{\link{validate_gmean_byelt_LOO}} geometric mean
  by elements occurring within assembly motif \cr
}
\keyword{internal}
