% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_fdiv.R
\name{fd_fdiv}
\alias{fd_fdiv}
\title{Compute Functional Divergence (FDiv)}
\usage{
fd_fdiv(traits, sp_com)
}
\arguments{
\item{traits}{Trait matrix with species as rows and traits as columns.
It has to contain exclusively numerical values. This can be
either a \code{matrix}, a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}}
object.}

\item{sp_com}{Site-species matrix with sites as rows and species as columns
if not provided, the function considers all species with equal
abundance in a single site. This can be either a \code{matrix},
a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.}
}
\value{
a data.frame with two columns:
\itemize{
\item \code{site} the names of the sites as the row names of the input \code{sp_com},
\item \code{FDiv} the values of functional divergence at each site.
}

NB: when a site contains no species FDiv is equal to 0.
}
\description{
Compute Functional Divergence (FDiv)
}
\details{
By default, when loading \pkg{fundiversity}, the functions to
compute convex hulls are
\href{https://en.wikipedia.org/wiki/Memoization}{memoised} through the \code{memoise}
package if it is installed. To deactivate this behavior you can set the
option \code{fundiversity.memoise} to \code{FALSE} by running the following line:
\code{options(fundiversity.memoise = FALSE)}. If you use it interactively it will
only affect your current session. Add it to your script(s) or \code{.Rprofile}
file to avoid toggling it each time.
}
\section{Parallelization}{

The computation of this function can be parallelized thanks to
\code{\link[future:plan]{future::plan()}}. To get more information on how to parallelize your
computation please refer to the parallelization vignette with:
\code{vignette("parallel", package = "fundiversity")}
}

\examples{
data(traits_birds)
fd_fdiv(traits_birds)

}
\references{
Villéger S., Mason N. W. H., Mouillot D. (2008), New multidimensional
functional diversity indices for a multifaceted framework in functional
ecology, Ecology 89(8), \doi{10.1890/07-1206.1}
}
