\name{tetcorQuasi}
\alias{tetcorQuasi}
\title{Correlation between a Naturally and an Artificially Dichotomized Variable}
\description{
 A function to compute Ulrich and Wirtz's correlation of a naturally and an artificially dichotomized variable. 
}
\usage{
tetcorQuasi(x, y = NULL)
}
\arguments{
 \item{x}{An N x 2 matrix or an N x 1 vector of binary responses coded 0/1.}
 \item{y}{An optional (if x is a vector) vector of 0/1 responses.}
}
\value{
\item{A quasi tetrachoric correlation}{...} 
}
\references{
Ulrich, R. & Wirtz, M. (2004). On the correlation of a naturally and an artificially dichotomized variable. \emph{British Journal of Mathematical and Statistical Psychology, 57}, 235-252.
}
\author{Niels Waller}
\examples{
set.seed(321)
Nsubj <- 5000

## Generate mvn data with rxy = .5
R <- matrix(c(1, .5, .5, 1), 2, 2)
X <- MASS::mvrnorm(n = Nsubj, mu = c(0, 0), Sigma = R, empirical = TRUE)

## dichotomize data
thresholds <- qnorm(c(.2, .3))
binaryData <- matrix(0, Nsubj, 2)

for(i in 1:2){
  binaryData[X[,i] <= thresholds[i],i] <- 1
}   

## calculate Pearson correlation
cat("\nPearson r: ", round(cor(X)[1,2], 2))

## calculate Pearson Phi correlation
cat("\nPhi r: ", round(cor(binaryData)[1,2], 2))

## calculate tetrachoric correlation
cat("\nTetrachoric r: ", round(tetcor(binaryData)$r[1,2], 2))

## calculate Quasi-tetrachoric correlation
cat("\nQuasi-tetrachoric r: ", round(tetcorQuasi(binaryData), 2))
}
\keyword{Statistics}% at least one, from doc/KEYWORDS
