% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_if.R
\name{group_if}
\alias{group_if}
\alias{group_eq}
\title{Group vector values}
\usage{
group_if(x, predicate, na.rm = FALSE)

group_eq(x, na.rm = FALSE)
}
\arguments{
\item{x}{a vector or a list to split into groups.}

\item{predicate}{a binary function returning a boolean value.}

\item{na.rm}{if x is atomic, delete missing values before grouping.}
}
\value{
A list where each element is a group (flattening this list should
  give back the same values in the same order). Element names are kept.
}
\description{
Split a vector or a list into groups, given a predicate function.
}
\details{
\code{predicate} will be applied to 2 adjacent elements. If it evaluates to
\code{TRUE}, those elements belong to the same group, otherwise they belong
to different groups.

Grouping on equality is the most natural approach, therefore \code{group_eq}
is a convenient shortcut defined as \itemize{
  \item{\code{group_if(x, predicate = `==`)} for an atomic vector;}
  \item{\code{group_if(x, predicate = identical)} for a list.}
}

\code{group_if} (resp. \code{group_eq}) is inspired by \code{groupBy} (resp.
\code{group}) in Haskell.
\emph{Note that \code{group_if} behaves a little differently : while in
Haskell, the comparison is made with the first element in the group, in this
R-version the comparison is made with the adjacent element.}

The operator \link{\%on\%} may be helpful to create a predicate with readable
syntax.
}
\examples{
x1 <- c(3, 4, 2, 2, 1, 1, 1, 3)
group_eq(x1)
group_if(x1, `<=`)
group_if(x1, function(x, y) abs(x - y) > 1)

x2 <- c(3, 4, 2, -2, -1, 1, 1, 3)
group_if(x2, `==` \%on\% abs)

x3 <- list(1:3, 1:3, 3:5, 1, 2)
group_if(x3, `==` \%on\% length)
}
