% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot-files.R
\name{unnest_results}
\alias{unnest_results}
\title{Unnest Results}
\usage{
unnest_results(df)
}
\arguments{
\item{df}{Dataframe outputted by \verb{spot_\{funs|pkgs\}_files()} that contains a
\code{spotted} list-column.}
}
\value{
An unnested dataframe with what was in \code{spotted} moved to the front.
}
\description{
Run after running \verb{list_files_*() |> spot_\{funs|pkgs\}_files()} to unnest the
\code{spotted} list-column.
}
\examples{
\donttest{
library(funspotr)
library(dplyr)

list_files_github_repo("brshallo/feat-eng-lags-presentation", branch = "main") \%>\%
  spot_funs_files() \%>\%
  unnest_results()
}
}
\seealso{
\code{\link[=spot_funs_files]{spot_funs_files()}}, \code{\link[=spot_pkgs_files]{spot_pkgs_files()}}
}
