% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-files-gh-gists.R
\name{list_files_github_gists}
\alias{list_files_github_gists}
\title{List Github Gists of User}
\usage{
list_files_github_gists(
  user,
  pattern = stringr::regex("(r|rmd|rmarkdown|qmd)$", ignore_case = TRUE)
)
}
\arguments{
\item{user}{Character string of username whose github gists you want to pull.}

\item{pattern}{Regex pattern to keep only matching files. Default is
\code{stringr::regex("(r|rmd|rmarkdown|qmd)$", ignore_case = TRUE)} which will
keep only R, Rmarkdown and Quarto documents. If you have a lot of .md gists
that can be converted to .R files you may want to edit this argument. To
keep all files use \code{"."}.}
}
\value{
Dataframe with \code{relative_paths} and \code{absolute_paths} of file paths.
Because gists do not exist in a folder structure \code{relative_paths} will
generally just be a file name. \code{absolute_paths} a url to the raw file. See
\code{unnest_results()} for helper to put into an easier to read format.
}
\description{
Given a username, return a dataframe with paths to all the gists by that user.
}
\examples{
\donttest{
library(dplyr)
library(funspotr)

# pulling and analyzing my R file github gists
gists_urls <- list_files_github_gists("brshallo", pattern = ".")

# Will just parse the first 2 files/gists
# Note that is easy to hit the API limit if have lots of gists
contents <- filter(gists_urls, str_detect_r_docs(absolute_paths)) \%>\%
  slice(1:2) \%>\%
  spot_funs_files()


contents \%>\%
  unnest_results()
}
}
\seealso{
\code{\link[=list_files_github_repo]{list_files_github_repo()}}, \code{\link[=list_files_wd]{list_files_wd()}}
}
