% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table1.R
\name{table1}
\alias{table1}
\title{Table 1 for Health, Behavioral, and Social Scientists}
\usage{
table1(.data, ..., splitby = NULL, splitby_labels = NULL, test = FALSE,
  test_type = "default", piping = FALSE, rounding = 3, var_names = NULL,
  format_output = "pvalues", output_type = "text", NAkeep = FALSE,
  m_label = "Missing", booktabs = TRUE, caption = NULL, align = NULL)
}
\arguments{
\item{.data}{the data.frame that is to be summarized}

\item{...}{variables in the data set that are to be summarized; unquoted names separated by commas (e.g. age, gender, race) or indices. If indices, it needs to be a single vector (e.g. c(1:5, 8, 9:20) instead of 1:5, 8, 9:20). As it is currently, it CANNOT handle both indices and unquoted names simultaneously.}

\item{splitby}{the categorical variable to stratify by in formula form (e.g., \code{splitby = ~gender}); not too surprisingly, it requires that the number of levels be > 0}

\item{splitby_labels}{allows for custom labels of the splitby levels; must match the number of levels of the splitby variable}

\item{test}{logical; if set to \code{TRUE} then the appropriate bivariate tests of significance are performed if splitby has more than 1 level}

\item{test_type}{has two options: "default" performs the default tests of significance only; "or" also give unadjusted odds ratios as well based on logistic regression (only use if splitby has 2 levels)}

\item{piping}{if \code{TRUE} then the table is printed and the original data is passed on. It is very useful in piping situations where one wants the table but wants it to be part of a larger pipe.}

\item{rounding}{the number of digits after the decimal; default is 3}

\item{var_names}{custom variable names to be printed in the table}

\item{format_output}{has three options: 1) "full" provides the table with the type of test, test statistic, and the p-value for each variable; 2) "pvalues" provides the table with the p-values; and 3) "stars" provides the table with stars indicating significance}

\item{output_type}{default is "text"; the other option is "latex" which uses the \code{kable()} function in \code{knitr}}

\item{NAkeep}{when sset to \code{TRUE} it also shows how many missing values are in the data for each categorical variable being summarized}

\item{m_label}{when \code{NAkeep = TRUE} this provides a label for the missing values in the table}

\item{booktabs}{when \code{output_type = "latex"}; option is passed to \code{knitr::kable}}

\item{caption}{when \code{output_type = "latex"}; option is passed to \code{knitr::kable}}

\item{align}{when \code{output_type = "latex"}; option is passed to \code{knitr::kable}}
}
\value{
A table with the number of observations, means/frequencies and standard deviations/percentages is returned. The object is a \code{table1} class object with a print method. Can be printed in \code{LaTex} form.
}
\description{
Produces a descriptive table, stratified by an optional categorical variable, 
providing means/frequencies and standard deviations/percentages. 
It is well-formatted for easy transition to academic article or report. 
Can be used within the piping framework [see library(magrittr)].
}
\examples{
## Data from MASS package ##
library(MASS)
data("birthwt")
library(dplyr)
b = mutate(.data=birthwt,
           smoke = as.factor(smoke),
           race  = as.factor(race),
           ht    = as.factor(ht),
           ui    = as.factor(ui))
levels(b$race) = c("white", "black", "other")

library(furniture)

table1(b, age, race, smoke, ptl, ht, ui, ftv, NAkeep=TRUE)
table1(b, age, race, smoke, ptl, ht, ui, ftv,
       splitby=~factor(low),
       NAkeep=TRUE)
       
b$low = as.factor(b$low)
table1(b, age, race, smoke, ptl, ht, ui, ftv,
       splitby=~low,
       test=TRUE,
       var_names = c("Age", "Race", "Smoking Status", "Previous Premature Labors", "Hypertension",
                     "Uterine Irratibility", "Physician Visits"),
       splitby_labels = c("Regular Birthweight", "Low Birthweight"))
       

}

