# WARNING - Generated by {fusen} from dev/flat_deal_with_flat_files.Rmd: do not edit by hand # nolint: line_length_linter.

dummypackage <- tempfile("rename")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(
  add_flat_template(
    template = "full",
    pkg = dummypackage,
    overwrite = TRUE,
    open = FALSE
  )
)
flat_file <- dev_file[grepl("flat_", dev_file)]

usethis::with_project(dummypackage, {
  # Create empty config file
  config_file <- file.path("dev", "config_fusen.yaml")
  write_yaml_verbatim(list(), config_file)

  test_that("rename_flat_file fails if file does not exists", {
    expect_error(
      rename_flat_file(flat_file = "dev/flat_nonexistent.Rmd"),
      regexp = "does not exist"
    )
  })

  new_name <- "flat_new.Rmd"
  new_path <- file.path("dev", new_name)

  test_that("rename_flat_file changes the name of the flat file", {
    rename_flat_file(flat_file = flat_file, new_name = new_name)
    expect_false(file.exists(flat_file))
    expect_true(file.exists(new_path))
  })

  test_that("rename_flat_file renames inside the flat file", {
    lines <- readLines(new_path)
    expect_equal(
      length(grep(flat_file, lines, fixed = TRUE)),
      0
    )
    expect_equal(
      length(grep(basename(flat_file), lines, fixed = TRUE)),
      0
    )
    expect_equal(
      length(grep(new_path, lines, fixed = TRUE)),
      1
    )
    expect_equal(
      length(grep(new_name, lines, fixed = TRUE)),
      2
    )
  })

  test_that(
    "rename_flat_file does not update config file if not previously present",
    {
      config <- yaml::read_yaml(config_file)
      expect_false(new_name %in% names(config))
    }
  )

  write_yaml_verbatim(
    list("flat_new.Rmd" = list(
      path = file.path("dev", "flat_new.Rmd")
    )),
    config_file
  )

  other_new_name <- "flat_other_new.Rmd"
  other_new_path <- file.path("dev", other_new_name)

  test_that("rename_flat_file changes the name of the flat file", {
    rename_flat_file(flat_file = new_path, new_name = other_new_name)
    expect_false(file.exists(new_path))
    expect_true(file.exists(other_new_path))
  })

  test_that("rename_flat_file updates the config file", {
    config <- yaml::read_yaml(config_file)
    expect_true(basename(other_new_path) %in% names(config))
    expect_true(is.null(config[[basename(new_path)]]))
    expect_equal(
      config[[basename(other_new_path)]][["path"]],
      other_new_path
    )
  })

  new_name2 <- "flat_new2.Rmd"
  new_name2_path <- file.path("dev", new_name2)


  test_that("rename_flat_file updates the inflated files in config", {
    # Inflate the new file
    suppressMessages(
      inflate(
        pkg = dummypackage,
        flat_file = other_new_path,
        vignette_name = "Get started",
        check = FALSE,
        open_vignette = FALSE
      )
    )

    # Rename the flat file
    rename_flat_file(flat_file = other_new_path, new_name = new_name2)

    # Check that the inflated files are updated
    config <- yaml::read_yaml(config_file)
    expect_equal(
      config[[basename(new_name2_path)]][["R"]],
      c("R/my_median.R", "R/my_other_median.R")
    )
  })

  test_that("rename_flat_file modifies sentence in inflated files", {
    config <- yaml::read_yaml(config_file)
    # Check that the inflated files are updated
    all_linked_files <- unlist(
      config[[basename(new_name2_path)]][
        c("R", "tests", "vignettes")
      ]
    )
    for (file in all_linked_files) {
      lines <- readLines(file)
      expect_false(
        any(grepl("flat_other_new.Rmd", lines))
      )
      expect_true(
        any(grepl("flat_new2.Rmd", lines))
      )
    }
  })

  test_that("rename_flat_file stops if new name already exists", {
    expect_error(
      rename_flat_file(flat_file = new_name2_path, new_name = new_name2),
      regexp = "already exists"
    )
  })

  new_name_path <- file.path("otherdev", "flat_new_with_path.Rmd")
  dir.create("otherdev")
  test_that("rename_flat_file accept path as a new name", {
    rename_flat_file(flat_file = new_name2_path, new_name = new_name_path)
    expect_false(file.exists(new_name2_path))
    expect_true(file.exists(new_name_path))
  })

  test_that("rename_flat_file still renames inside the flat file with path", {
    lines <- readLines(new_name_path)
    expect_equal(
      length(grep("flat_new2.Rmd", lines)),
      0
    )
    expect_equal(
      length(grep("dev/flat_new2.Rmd", lines)),
      0
    )
    expect_equal(
      length(grep("flat_new_with_path.Rmd", lines)),
      2
    )
    expect_equal(
      length(grep("otherdev/flat_new_with_path.Rmd", lines)),
      1
    )
  })
})
