% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fold.R
\name{fold}
\alias{fold}
\title{Efficient Fold, Reduce, Accumulate, Combine of a Vector}
\usage{
fold(x, f, left = TRUE, unname = TRUE, threshold = 1000L)
}
\arguments{
\item{x}{A vector.}

\item{f}{A binary function, i.e. a function take takes two arguments.}

\item{left}{If \code{TRUE}, vector is combined from the left (the first element),
otherwise the right (the last element).}

\item{unname}{If \code{TRUE}, function \code{f} is called as
\code{f(unname(y), x[[ii]])}, otherwise as \code{f(y, x[[ii]])},
which may introduce name \code{"y"}.}

\item{threshold}{An integer (>= 2) specifying the length where the
recursive divide-and-conquer call will stop and incremental building of
the partial value is performed.  Using \code{threshold = +Inf} will disable
recursive folding.}
}
\value{
A vector.
}
\description{
Efficient Fold, Reduce, Accumulate, Combine of a Vector
}
\details{
In order for recursive folding to give the same results as non-recursive
folding, binary function \code{f} must be \emph{associative} with itself, i.e.
\code{f(f(x[[1]], x[[2]]), x[[3]])} equals
\code{f(x[[1]], f(x[[2]]), x[[3]])}.

This function is a more efficient (memory and speed) of
\code{\link[base:Reduce]{Reduce(f, x, right = !left, accumulate = FALSE)}},
especially when \code{x} is long.
}
\keyword{internal}
