% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng.R
\name{make_rng_seeds}
\alias{make_rng_seeds}
\title{Produce Reproducible Seeds for Parallel Random Number Generation}
\usage{
make_rng_seeds(count, seed = FALSE, debug = NA)
}
\arguments{
\item{count}{The number of RNG seeds to produce.}

\item{seed}{A logical specifying whether RNG seeds should be generated
or not.  (\code{seed = NULL} corresponds to \code{seed = FALSE}).
If a list, then it should be of length \code{count} and each element should
consist of a valid RNG seed.}

\item{debug}{If \code{TRUE}, debug output is produced, otherwise not.}
}
\value{
Returns a non-named list of length \code{count}, or \code{NULL}.
Any seed returned is a valid RNG seed.
}
\description{
Produce Reproducible Seeds for Parallel Random Number Generation
}
\keyword{internal}
