% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwb.ci.R
\name{get_ci}
\alias{get_ci}
\title{Extract Confidence Intervals from a \code{bootci} Object}
\usage{
get_ci(x, type = "all")
}
\arguments{
\item{x}{a \code{bootci} object; the output of a call to \code{boot::boot.ci()} or \code{fwb.ci()}.}

\item{type}{the type of confidence intervals to extract. Only those available in \code{x} are allowed. Should be a given as a subset of the types passed to \code{type} in \code{boot.ci()} or \code{fwb.ci()}. The default, \code{"all"}, extracts all confidence intervals in \code{x}.}
}
\value{
A list with an entry for each confidence interval type; each entry is a numeric vector of length 2 with names \code{"L"} and \code{"U"} for the lower and upper interval bounds, respectively. The \code{"conf"} attribute contains the confidence level.
}
\description{
\code{get_ci()} extracts the confidence intervals from the output of a call to \pkgfun{boot}{boot.ci} or \code{\link[=fwb.ci]{fwb.ci()}} in a clean way. Normally the confidence intervals can be a bit challenging to extract because of the unusual structure of the object.
}
\examples{
#See example at help("fwb.ci")

}
\seealso{
\code{\link[=fwb.ci]{fwb.ci()}}, \pkgfun{boot}{boot.ci}
}
