% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{antv_dagre_layout}
\alias{antv_dagre_layout}
\title{Generate G6 AntV Dagre layout configuration}
\usage{
antv_dagre_layout(
  rankdir = c("TB", "BT", "LR", "RL"),
  align = c("UL", "UR", "DL", "DR"),
  nodesep = 50,
  nodesepFunc = NULL,
  ranksep = 100,
  ranksepFunc = NULL,
  ranker = c("network-simplex", "tight-tree", "longest-path"),
  nodeSize = NULL,
  controlPoints = FALSE,
  begin = NULL,
  sortByCombo = FALSE,
  edgeLabelSpace = TRUE,
  nodeOrder = NULL,
  radial = FALSE,
  focusNode = NULL,
  preset = NULL,
  ...
)
}
\arguments{
\item{rankdir}{Layout direction: "TB" (top to bottom), "BT" (bottom to top),
"LR" (left to right), or "RL" (right to left).}

\item{align}{Node alignment: "UL" (upper left), "UR" (upper right),
"DL" (down left), or "DR" (down right).}

\item{nodesep}{Node spacing (px). When rankdir is "TB" or "BT", it's the horizontal.
spacing of nodes; when rankdir is "LR" or "RL", it's the vertical spacing of nodes.}

\item{nodesepFunc}{Function to customize node spacing for different nodes,
in the form of function(node) that returns a number. Has higher priority than nodesep.}

\item{ranksep}{Layer spacing (px). When rankdir is "TB" or "BT", it's the vertical spacing
between adjacent layers; when rankdir is "LR" or "RL", it's the horizontal spacing.}

\item{ranksepFunc}{Function to customize layer spacing, in the form of function(node)
that returns a number. Has higher priority than ranksep.}

\item{ranker}{Algorithm for assigning ranks to nodes: "network-simplex", "tight-tree",
or "longest-path".}

\item{nodeSize}{Node size for collision detection. Can be a single number (same width/height),
an array \code{[width, height]}, or a function that returns either.}

\item{controlPoints}{Whether to retain edge control points.}

\item{begin}{Alignment position of the upper left corner of the layout.
Can be \code{[x, y]} or \code{[x, y, z]}.}

\item{sortByCombo}{Whether to sort nodes on the same layer by parentId to prevent combo overlap.}

\item{edgeLabelSpace}{Whether to leave space for edge labels.}

\item{nodeOrder}{Reference array of node order on the same layer, containing node id values.}

\item{radial}{Whether to perform a radial layout based on dagre.}

\item{focusNode}{Focused node (only used when radial=TRUE). Can be a node ID or node object.}

\item{preset}{Node positions to reference during layout calculation.}

\item{...}{Additional parameters to pass to the layout.}
}
\value{
A list containing the configuration for G6 AntV Dagre layout.
}
\description{
This function creates a configuration list for G6 AntV Dagre layout
with all available options as parameters.
}
\examples{
# Basic dagre layout
dagre_config <- antv_dagre_layout()

# Horizontal layout with custom spacing
dagre_config <- antv_dagre_layout(
  rankdir = "LR",
  align = "UL",
  nodesep = 80,
  ranksep = 150
)

# Radial layout with focus node
dagre_config <- antv_dagre_layout(
  radial = TRUE,
  focusNode = "node1",
  ranker = "tight-tree"
)
}
