/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.af.commons.Localizer;
import org.apache.commons.lang.ArrayUtils;
import org.mutoss.config.Configuration;
import org.mutoss.gui.MenuBarMGraph;
import org.mutoss.gui.RControl;
import org.mutoss.gui.datatable.CellEditorE;
import org.mutoss.gui.datatable.DataFramePanel;
import org.mutoss.gui.datatable.DataTable;
import org.mutoss.gui.datatable.RDataFrameRef;
import org.mutoss.gui.graph.EdgeWeight;
import org.mutoss.gui.graph.GraphMCP;
import org.mutoss.gui.graph.GraphView;
import org.mutoss.gui.graph.PView;

public class CreateGraphGUI
extends JFrame
implements WindowListener {
    GraphMCP graph;
    GraphView agc;
    PView pview;
    DataFramePanel dfp;
    static String graphStr;
    static boolean debug;
    static double grid;

    public CreateGraphGUI(String graph, double[] pvalues, boolean debug, double grid) {
        super("Creating and modifying graphs");
        Locale.setDefault(Locale.US);
        JComponent.setDefaultLocale(Locale.US);
        RControl.getRControl(debug);
        Localizer.getInstance().addResourceBundle("org.mutoss.gui.ResourceBundle");
        if (grid > 0.0) {
            Configuration.getInstance().getGeneralConfig().setGridSize((int)grid);
        }
        Configuration.getInstance().getGeneralConfig().setVersionNumber(RControl.getR().eval("as.character(packageVersion(\"gMCP\"))").asRChar().getData()[0]);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/mutoss/gui/graph/images/rjavaicon64.png")).getImage());
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.addWindowListener(this);
        this.pview = new PView(this);
        this.dfp = new DataFramePanel(new RDataFrameRef());
        this.agc = new GraphView(graph, this);
        this.setJMenuBar(new MenuBarMGraph(this.agc));
        this.makeContent();
        this.graph = new GraphMCP(graph, this.agc.getVS());
        if (pvalues.length > 0) {
            this.getPView().setPValues(ArrayUtils.toObject((double[])pvalues));
        }
        this.setVisible(true);
    }

    public static void startGUI(String graphStr, boolean debug, double grid) {
        CreateGraphGUI.graphStr = graphStr;
        CreateGraphGUI.debug = debug;
        CreateGraphGUI.grid = grid;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new CreateGraphGUI(graphStr, new double[0], debug, grid);
            }
        });
    }

    private void makeContent() {
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(this.agc));
        JSplitPane splitPane2 = new JSplitPane(0, new JScrollPane(this.dfp), new JScrollPane(this.pview));
        JSplitPane splitPane = new JSplitPane(1, this.agc, splitPane2);
        this.getContentPane().add(splitPane);
    }

    public static void main(String[] args) {
        new CreateGraphGUI("graph", new double[0], true, 10.0);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public PView getPView() {
        return this.pview;
    }

    public GraphView getGraphView() {
        return this.agc;
    }

    public DataTable getDataTable() {
        return this.dfp.getTable();
    }
}

