% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gMCP.R
\name{rejectNode}
\alias{rejectNode}
\title{Rejects a node/hypothesis and updates the graph accordingly.}
\usage{
rejectNode(graph, node, upscale = FALSE, verbose = FALSE,
  keepWeights = FALSE)
}
\arguments{
\item{graph}{A graph of class \code{\link{graphMCP}} or \code{\link{entangledMCP}}.}

\item{node}{A character string specifying the node to reject.}

\item{upscale}{Logical. If \code{upscale=TRUE} then the weights of all non-rejected
nodes are scaled so that the sum is equal to 1. This forces \code{keepWeights=FALSE}
to reduce confusion, since otherwise the sum of weights could become bigger than 1.}

\item{verbose}{Logical scalar.  If \code{TRUE} verbose output is generated
during sequentially rejection steps.}

\item{keepWeights}{Logical scalar. If \code{FALSE} the weight of a node
without outgoing edges is set to 0 if it is removed.  Otherwise it keeps its
weight.}
}
\value{
An updated graph of class \code{\link{graphMCP}} or \code{\link{entangledMCP}}.
}
\description{
Rejects a node/hypothesis and updates the graph accordingly.
}
\details{
For details see the given references.
}
\examples{
g <- BonferroniHolm(5)

rejectNode(g, "H1")
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\references{
Frank Bretz, Willi Maurer, Werner Brannath, Martin Posch: A
graphical approach to sequentially rejective multiple test procedures.
Statistics in Medicine 2009 vol. 28 issue 4 page 586-604.
\url{http://www.meduniwien.ac.at/fwf_adaptive/papers/bretz_2009_22.pdf}
}
\seealso{
\code{\link{graphMCP}}
}
\keyword{graphs}
\keyword{htest}

