/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.config;

import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.config.SpecificConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralConfig
extends SpecificConfig {
    public static final String DISABLE = "disable";
    DecimalFormat format = null;

    GeneralConfig(Configuration conf) {
        super(conf);
    }

    public void setTempDir(String tempDir) {
        this.setProperty("tempdir", tempDir);
    }

    public String getTempDir() {
        String tmpDir = this.getProperty("tempdir", "");
        if (tmpDir.trim().equals("")) {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        return tmpDir;
    }

    public void setPDFViewerPath(String pdfViewerPath) {
        this.setProperty("acrobat.path", pdfViewerPath);
    }

    public String getPDFViewerPath() {
        return this.getProperty("acrobat.path", "");
    }

    public void setPDFViewerOptions(String pdfViewerOptions) {
        this.setProperty("pdfviewer.options", pdfViewerOptions);
    }

    public String getPDFViewerOptions() {
        return this.getProperty("pdfviewer.options", "");
    }

    public void setFontSize(int i) {
        this.setIntProperty("font.size", i);
    }

    public int getFontSize() {
        return this.getIntProperty("font.size", "12");
    }

    public void setGridSize(int grid) {
        this.setProperty("grid", "" + Math.max(grid, 1));
    }

    public int getGridSize() {
        int grid = Integer.parseInt(this.getProperty("grid", "50"));
        return Math.max(1, grid);
    }

    public void setDigits(int digit) {
        this.setProperty("Digits", "" + digit);
        this.setFormat();
    }

    public int getDigits() {
        return Integer.parseInt(this.getProperty("Digits", "3"));
    }

    public DecimalFormat getDecFormat() {
        if (this.format == null) {
            this.setFormat();
        }
        return this.format;
    }

    private void setFormat() {
        String s = "#.";
        for (int i = 0; i < this.getDigits(); ++i) {
            s = s + "#";
        }
        this.format = new DecimalFormat(s);
    }

    public void setLineWidth(int lw) {
        this.setProperty("linewidth", "" + lw);
    }

    public int getLineWidth() {
        return Integer.parseInt(this.getProperty("linewidth", "2"));
    }

    public void setEps(double eps) {
        this.setProperty("epsilon", "" + eps);
    }

    public double getEpsilon() {
        return Double.parseDouble(this.getProperty("epsilon", "0.0001"));
    }

    public boolean showFractions() {
        return Boolean.parseBoolean(this.getProperty("showFractions", "true"));
    }

    public void setShowFractions(boolean showFractions) {
        this.setProperty("showFractions", "" + showFractions);
    }

    public boolean getColoredImages() {
        return Boolean.parseBoolean(this.getProperty("coloredImages", "true"));
    }

    public void setColoredImages(boolean colored) {
        this.setProperty("coloredImages", "" + colored);
    }

    public int getDigitsInTables() {
        return Integer.parseInt(this.getProperty("digits.in.tables", "6"));
    }

    public boolean showRejected() {
        return Boolean.parseBoolean(this.getProperty("showRejected", "true"));
    }

    public void setShowRejected(boolean showRejected) {
        this.setProperty("showRejected", "" + showRejected);
    }

    public boolean useEpsApprox() {
        return Boolean.parseBoolean(this.getProperty("useEpsApprox", "true"));
    }

    public void setUseEpsApprox(boolean useEpsApprox) {
        this.setProperty("useEpsApprox", "" + useEpsApprox);
    }

    public boolean useJLaTeXMath() {
        return Boolean.parseBoolean(this.getProperty("useJLaTeXMath", "true"));
    }

    public void setUseJLaTeXMath(boolean useJLaTeXMath) {
        this.setProperty("useJLaTeXMath", "" + useJLaTeXMath);
    }

    public boolean checkOnline() {
        return Boolean.parseBoolean(this.getProperty("checkOnline", "true"));
    }

    public void setCheckOnline(boolean checkOnline) {
        this.setProperty("checkOnline", "" + checkOnline);
    }

    public boolean tellAboutCheckOnline() {
        return Boolean.parseBoolean(this.getProperty("tellAboutCheckOnline", "false"));
    }

    public void setTellAboutCheckOnline(boolean checkOnline) {
        this.setProperty("tellAboutCheckOnline", "" + checkOnline);
    }

    public boolean reminderNewVersion() {
        return Boolean.parseBoolean(this.getProperty("reminderNewVersion", "true"));
    }

    public void setReminderNewVersion(boolean reminderNewVersion) {
        this.setProperty("reminderNewVersion", "" + reminderNewVersion);
    }

    public void setVersionNumber(String version) {
        this.setProperty("gMCPversion", version);
    }

    public String getVersionNumber() {
        return this.getProperty("gMCPversion", "<= 0.6.0");
    }

    public void setRVersionNumber(String version) {
        this.setProperty("Rversion", version);
    }

    public String getRVersionNumber() {
        return this.getProperty("Rversion", "unknown");
    }

    public void setRandomID() {
        this.setProperty("randomID", "" + Math.abs(new Random().nextInt()));
    }

    public String getRandomID() {
        if (this.getProperty("randomID", "NOT_SET_YET").equals("NOT_SET_YET")) {
            this.setRandomID();
        }
        return this.getProperty("randomID");
    }

    public List<String> getLatestGraphs() {
        Vector<String> graphs = new Vector<String>();
        for (int i = 0; i < 4; ++i) {
            String graph = this.getProperty("saved_graph_" + i, "NOT_SAVED_YET");
            if (!graph.startsWith("R Object") && !new File(graph).exists()) continue;
            graphs.add(graph);
        }
        return graphs;
    }

    public void addGraph(String graph) {
        int i;
        for (i = 1; i < 4 && !graph.equals(this.getProperty("saved_graph_" + (i - 1), "NOT_SAVED_YET")); ++i) {
        }
        --i;
        while (i > 0) {
            String g = this.getProperty("saved_graph_" + (i - 1), "NOT_SAVED_YET");
            this.setProperty("saved_graph_" + i, g);
            --i;
        }
        this.setProperty("saved_graph_0", graph);
    }

    public int getNumberOfStarts() {
        return Integer.parseInt(this.getProperty("NumberOfStarts", "0"));
    }

    public void setNumberOfStarts(int i) {
        this.setProperty("NumberOfStarts", "" + i);
    }

    public String getTimesSymbol() {
        return this.getProperty("getTimesSymbol", "");
    }

    public void setTimesSymbol(String s) {
        this.setProperty("getTimesSymbol", s);
    }

    public double getAccuracy() {
        return Double.parseDouble(this.getProperty("fractionAccuracy", "0.000001"));
    }

    public void setExperimental(boolean b) {
        this.setProperty("experimentalFeatures", "" + b);
    }

    public boolean experimentalFeatures() {
        return Boolean.parseBoolean(this.getProperty("experimentalFeatures", "true"));
    }

    public void setVerbose(boolean b) {
        this.setProperty("verbose", "" + b);
    }

    public boolean verbose() {
        return Boolean.parseBoolean(this.getProperty("verbose", "true"));
    }

    public void setVariable(String variable, double value) {
        this.setProperty("Variable_" + variable, "" + value);
    }

    public double getVariable(String variable) {
        return Double.parseDouble(this.getProperty("Variable_" + variable, "0.5"));
    }

    public boolean exportTransparent() {
        return Boolean.parseBoolean(this.getProperty("exportTransparent", "true"));
    }

    public void setExportTransparent(boolean b) {
        this.setProperty("exportTransparent", "" + b);
    }

    public boolean getUnAnchor() {
        return Boolean.parseBoolean(this.getProperty("unAnchor", "true"));
    }

    public void setUnAnchor(boolean b) {
        this.setProperty("unAnchor", "" + b);
    }

    public boolean simplify() {
        return Boolean.parseBoolean(this.getProperty("simplify", "false"));
    }

    public int getDigits2() {
        return Integer.parseInt(this.getProperty("digits2", "6"));
    }

    public void setSimplify(boolean b) {
        this.setProperty("simplify", "" + b);
    }

    public void setDigits2(int digits2) {
        this.setProperty("digits2", "" + digits2);
    }

    public Integer getNumberOfSimulations() {
        return Integer.parseInt(this.getProperty("numberOfSimulations", "10000"));
    }

    public String getTypeOfRandom() {
        return this.getProperty("typeOfRandom", "quasirandom");
    }

    public void setNumberOfSimulations(int nr) {
        this.setProperty("numberOfSimulations", "" + nr);
    }

    public void setTypeOfRandom(String type) {
        this.setProperty("typeOfRandom", "" + type);
    }

    public boolean focusEqualsEdit() {
        return Boolean.parseBoolean(this.getProperty("focusEqualsEdit", "true"));
    }

    public void setFocusEqualsEdit(boolean b) {
        this.setProperty("focusEqualsEdit", "" + b);
    }

    public boolean askWhenGraphIsNotSaved() {
        return Boolean.parseBoolean(this.getProperty("askWhenGraphIsNotSaved", "false"));
    }

    public boolean markEpsilon() {
        return Boolean.parseBoolean(this.getProperty("markEpsilon", "true"));
    }

    public void setMarkEpsilon(boolean b) {
        this.setProperty("markEpsilon", "" + b);
    }

    public String getEnvir() {
        return this.getProperty("envir", ", envir=get(\"env\", gMCP:::gMCPenv)");
    }

    public void setEnvir(String envir) {
        this.setProperty("envir", envir);
    }

    public String getParametricTest() {
        return this.getProperty("parametricTest", "Bretz2011");
    }

    public void setParametricTest(String test) {
        this.setProperty("parametricTest", test);
    }

    public Double getExportZoom() {
        return this.getProperty("Exportzoom", "null") == "null" ? null : Double.valueOf(Double.parseDouble(this.getProperty("Exportzoom", "null")));
    }

    public void setShowRCode(boolean b) {
        this.setProperty("showRCode", "" + b);
    }

    public boolean showRCode() {
        return Boolean.parseBoolean(this.getProperty("showRCode", "true"));
    }
}

