/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileFilter;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.tools.OSTools;
import org.af.commons.widgets.DesktopPaneBG;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.ReproducableLog;
import org.af.gMCP.gui.datatable.DataFramePanel;
import org.af.gMCP.gui.dialogs.AdjustedPValueDialog;
import org.af.gMCP.gui.dialogs.DialogConfIntEstVar;
import org.af.gMCP.gui.dialogs.RejectedDialog;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.DView;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.PView;
import org.af.gMCP.gui.graph.WrongInputException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingworker.SwingWorker;
import org.mutoss.gui.TransferableImage;

public class GraphView
extends JPanel
implements ActionListener {
    String name;
    CreateGraphGUI parent;
    public static final String STATUSBAR_DEFAULT = "Place new nodes and edges or start the test procedure";
    JLabel statusBar;
    public NetList nl;
    JToggleButton buttonNewNode;
    JButton buttonNewEdge;
    JButton buttonZoomOut;
    JButton buttonZoomIn;
    JButton buttonadjPval;
    JButton buttonConfInt;
    JButton buttonStart;
    JButton buttonBack;
    String alternatives;
    String correlation = "";
    public String result = ".gMCPResult_" + new Date().getTime();
    protected boolean resultUpToDate = false;
    private static final Log logger = LogFactory.getLog(GraphView.class);
    String rCode = "";
    public boolean isGraphSaved = true;

    public String getGraphName() {
        return this.name;
    }

    public CreateGraphGUI getMainFrame() {
        return this.parent;
    }

    public PView getPView() {
        return this.parent.getPView();
    }

    public void updateEdge(int from, int to, Double w, int layer) {
        this.updateEdge(from, to, new EdgeWeight(w), layer);
    }

    public CreateGraphGUI getGraphGUI() {
        return this.parent;
    }

    public GraphView(String graph, CreateGraphGUI createGraphGUI) {
        this.name = graph;
        this.parent = createGraphGUI;
        this.statusBar = new JLabel(STATUSBAR_DEFAULT);
        this.nl = new NetList(this.statusBar, this);
        this.setLayout(new BorderLayout());
        this.add("North", this.getNorthPanel());
        JScrollPane sPane = new JScrollPane(this.nl);
        this.add("Center", sPane);
    }

    public void setGraphName(String name) {
        this.name = name;
    }

    public JPanel getNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.getToolBar());
        panel.add("South", this.statusBar);
        return panel;
    }

    public JPanel getToolBar() {
        JPanel toolPanel = new JPanel();
        try {
            toolPanel.setLayout(new FlowLayout());
            ((FlowLayout)toolPanel.getLayout()).setAlignment(0);
            this.buttonNewNode = new JToggleButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/vertex.png"))));
            toolPanel.add(this.buttonNewNode);
            this.buttonNewNode.addActionListener(this);
            this.buttonNewNode.setToolTipText("new vertex");
            this.buttonNewEdge = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/edge.png"))));
            toolPanel.add(this.buttonNewEdge);
            this.buttonNewEdge.addActionListener(this);
            this.buttonNewEdge.setToolTipText("new edge");
            this.buttonZoomOut = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/zoom_out.png"))));
            toolPanel.add(this.buttonZoomOut);
            this.buttonZoomOut.addActionListener(this);
            this.buttonZoomOut.setToolTipText("zoom out");
            this.buttonZoomIn = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/zoom_in.png"))));
            toolPanel.add(this.buttonZoomIn);
            this.buttonZoomIn.addActionListener(this);
            this.buttonZoomIn.setToolTipText("zoom in");
            this.buttonStart = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/StartTesting.png"))));
            toolPanel.add(this.buttonStart);
            this.buttonStart.addActionListener(this);
            this.buttonStart.setEnabled(false);
            this.buttonStart.setToolTipText("start testing");
            this.buttonadjPval = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/adjPval.png"))));
            toolPanel.add(this.buttonadjPval);
            this.buttonadjPval.addActionListener(this);
            this.buttonadjPval.setEnabled(false);
            this.buttonadjPval.setToolTipText("calculate adjusted p-values");
            this.buttonConfInt = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/confint2.png"))));
            toolPanel.add(this.buttonConfInt);
            this.buttonConfInt.addActionListener(this);
            this.buttonConfInt.setEnabled(false);
            this.buttonConfInt.setToolTipText("calculate confidence intervals");
        }
        catch (IOException e) {
            ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e);
        }
        return toolPanel;
    }

    public NetList getNL() {
        return this.nl;
    }

    public void actionPerformed(ActionEvent e) {
        if (!e.getSource().equals(this.buttonNewNode)) {
            this.nl.newVertex = false;
            this.buttonNewNode.setSelected(false);
        }
        if (!e.getSource().equals(this.buttonNewEdge)) {
            this.nl.newEdge = false;
            this.nl.arrowHeadPoint = null;
            this.nl.firstVertexSelected = false;
        }
        if (e.getSource().equals(this.buttonZoomIn)) {
            this.nl.setZoom(this.nl.getZoom() * 1.25);
            this.getNL().refresh();
        } else if (e.getSource().equals(this.buttonZoomOut)) {
            if (this.nl.getZoom() > 0.025) {
                this.nl.setZoom(this.nl.getZoom() / 1.25);
                this.getNL().refresh();
            } else {
                JOptionPane.showMessageDialog(this.parent, "Highest zoom level. This is no Mandelbrot set.", "Highest zoom level", 1);
            }
        } else if (e.getSource().equals(this.buttonNewEdge)) {
            ReproducableLog.logGUI("Button \"new edge\"");
            this.nl.newEdge = true;
            this.getNL().statusBar.setText("Select a node from which this edge should start.");
        } else if (e.getSource().equals(this.buttonNewNode)) {
            ReproducableLog.logGUI("Button \"new node\"");
            this.nl.newVertex = this.buttonNewNode.isSelected();
            this.nl.repaint();
            this.getNL().statusBar.setText("Click on the graph panel to place the node.");
        } else if (e.getSource().equals(this.buttonConfInt)) {
            ReproducableLog.logGUI("Button \"confint\"");
            if (!this.getNL().isTesting()) {
                this.getPView().savePValues();
                this.getNL().saveGraph(this.getNL().resetGraph, false, false);
                this.getNL().saveGraphWithoutVariables(this.getNL().initialGraph, false, false);
                this.getNL().loadGraph();
                this.getPView().restorePValues();
                this.showParamInfo();
            }
            if (this.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.parent, "Please create first a graph.", "Please create first a graph.", 0);
            } else {
                this.parent.glassPane.start();
                this.correlation = this.parent.getPView().getParameters();
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    protected Void doInBackground() throws Exception {
                        try {
                            if (!GraphView.this.isResultUpToDate()) {
                                RControl.getR().evalVoid(GraphView.this.result + " <- gMCP(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")");
                                GraphView.this.rCode = RControl.getR().eval("gMCP:::createGMCPCall(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")").asRChar().getData()[0];
                                GraphView.this.setResultUpToDate(true);
                            }
                            double[] alpha = RControl.getR().eval("" + GraphView.this.getPView().getTotalAlpha() + "*getWeights(" + GraphView.this.result + ")").asRNumeric().getData();
                            boolean[] rejected = RControl.getR().eval("getRejected(" + GraphView.this.result + ")").asRLogical().getData();
                            GraphView.this.parent.glassPane.stop();
                            new DialogConfIntEstVar(GraphView.this.parent, GraphView.this.nl, rejected, alpha);
                        }
                        catch (Exception ex) {
                            if (ex instanceof WrongInputException) {
                                GraphView.this.parent.glassPane.stop();
                                return null;
                            }
                            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        } else if (e.getSource().equals(this.buttonStart)) {
            ReproducableLog.logGUI("Button \"start testing\"");
            if (!this.getNL().isTesting()) {
                this.getPView().savePValues();
                this.getNL().saveGraph(this.getNL().resetGraph, false, false);
                this.getNL().saveGraphWithoutVariables(this.getNL().initialGraph, false, false);
                this.getNL().loadGraph();
                this.getPView().restorePValues();
                this.showParamInfo();
                this.parent.glassPane.start();
                this.startTesting();
                this.correlation = this.parent.getPView().getParameters();
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    protected Void doInBackground() throws Exception {
                        try {
                            if (!GraphView.this.isResultUpToDate()) {
                                RControl.getR().evalVoid(GraphView.this.result + " <- gMCP(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")");
                                GraphView.this.rCode = RControl.getR().eval("gMCP:::createGMCPCall(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")").asRChar().getData()[0];
                                GraphView.this.setResultUpToDate(true);
                            }
                            boolean[] rejected = RControl.getR().eval(GraphView.this.result + "@rejected").asRLogical().getData();
                            String output = null;
                            if (Configuration.getInstance().getGeneralConfig().verbose() && RControl.getR().eval("!is.null(attr(" + GraphView.this.result + ", \"output\"))").asRLogical().getData()[0]) {
                                output = RControl.getR().eval("attr(" + GraphView.this.result + ", \"output\")").asRChar().getData()[0];
                            }
                            GraphView.this.parent.glassPane.stop();
                            new RejectedDialog(GraphView.this.parent, rejected, GraphView.this.parent.getGraphView().getNL().getNodes(), output, GraphView.this.rCode);
                        }
                        catch (Exception ex) {
                            if (ex instanceof WrongInputException) {
                                GraphView.this.parent.glassPane.stop();
                                return null;
                            }
                            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
                        }
                        return null;
                    }
                };
                worker.execute();
            } else {
                this.stopTesting();
            }
        } else if (e.getSource().equals(this.buttonadjPval)) {
            ReproducableLog.logGUI("Button \"calculate p-values\"");
            if (this.getNL().getNodes().size() == 0) {
                JOptionPane.showMessageDialog(this.parent, "Please create first a graph.", "Please create first a graph.", 0);
            } else {
                if (!this.getNL().isTesting()) {
                    this.getPView().savePValues();
                    this.getNL().saveGraph(this.getNL().resetGraph, false, false);
                    this.getNL().saveGraphWithoutVariables(this.getNL().initialGraph, false, false);
                    this.getNL().loadGraph();
                    this.getPView().restorePValues();
                    this.showParamInfo();
                }
                this.parent.glassPane.start();
                this.correlation = this.parent.getPView().getParameters();
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    protected Void doInBackground() throws Exception {
                        try {
                            if (!GraphView.this.isResultUpToDate()) {
                                RControl.getR().evalVoid(GraphView.this.result + " <- gMCP(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")");
                                GraphView.this.rCode = RControl.getR().eval("gMCP:::createGMCPCall(" + GraphView.this.getNL().initialGraph + GraphView.this.getGMCPOptions() + ")").asRChar().getData()[0];
                                GraphView.this.setResultUpToDate(true);
                            }
                            double[] adjPValues = RControl.getR().eval(GraphView.this.result + "@adjPValues").asRNumeric().getData();
                            GraphView.this.parent.glassPane.stop();
                            new AdjustedPValueDialog(GraphView.this.parent, GraphView.this.getPView().pValues, adjPValues, GraphView.this.getNL().getNodes());
                        }
                        catch (Exception ex) {
                            if (ex instanceof WrongInputException) {
                                GraphView.this.parent.glassPane.stop();
                                return null;
                            }
                            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        }
    }

    private void showParamInfo() {
        if (this.parent.getPView().jrbRCorrelation.isSelected() && !Configuration.getInstance().getClassProperty(this.getClass(), "showParamInfo", "yes").equals("no")) {
            JCheckBox tellMeAgain = new JCheckBox("Don't show me this info again.");
            String message = "The parametric test that takes correlation into\naccount is appropriate if the p-values\nbelong to one-sided test-statistics with a joint\nmultivariate normal distribution under the null.\n(The Bonferroni- and Simes-based tests do not\nneed this assumption).";
            JOptionPane.showMessageDialog(this.parent, new Object[]{message, tellMeAgain}, "Info", 1);
            if (tellMeAgain.isSelected()) {
                Configuration.getInstance().setClassProperty(this.getClass(), "showParamInfo", "no");
            }
        }
    }

    public void stopTesting() {
        if (!this.getNL().testingStarted) {
            return;
        }
        this.getNL().stopTesting();
        this.getNL().reset();
        this.getNL().loadGraph(this.getNL().resetGraph);
        this.getDataFramePanel().setTesting(false);
        this.getPView().restorePValues();
        this.getPView().setTesting(false);
        this.getPView().revalidate();
        this.getPView().repaint();
        this.buttonNewNode.setEnabled(true);
        this.buttonNewEdge.setEnabled(true);
        try {
            this.buttonStart.setIcon(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/StartTesting.png"))));
        }
        catch (IOException ex) {
            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
        }
    }

    public void startTesting() {
        if (this.getNL().testingStarted || !this.getPView().jrbNoCorrelation.isSelected()) {
            return;
        }
        this.getPView().savePValues();
        try {
            this.getNL().startTesting();
            this.getNL().saveGraph(false);
            this.getDataFramePanel().setTesting(true);
            this.getPView().setTesting(true);
            this.buttonNewNode.setEnabled(false);
            this.buttonNewEdge.setEnabled(false);
            this.buttonStart.setIcon(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/Reset.png"))));
        }
        catch (Exception ex) {
            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
        }
    }

    public void WriteLaTeXwithR() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this.getMainFrame());
        if (returnVal != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        String filename = file.getAbsolutePath();
        this.nl.saveGraph(".exportGraphToLaTeX", false, false);
        RControl.getR().eval("gMCPReport(.exportGraphToLaTeX, file=\"" + filename + "\")");
    }

    public void updateEdge(int from, int to, EdgeWeight weight, int layer) {
        logger.info((Object)("Adding Edge from " + from + " to " + to + " with weight " + weight.toString() + "."));
        Edge e = this.getNL().findEdge(this.getNL().getNodes().get(from), this.getNL().getNodes().get(to), layer);
        if (e != null) {
            int x = e.getK1();
            int y = e.getK2();
            if (!weight.toString().equals("0")) {
                this.getNL().setEdge(new Edge(this.getNL().getNodes().get(from), this.getNL().getNodes().get(to), weight, this.getNL(), x, y, layer));
            } else {
                this.getNL().removeEdge(e);
            }
        } else {
            this.getNL().setEdge(this.getNL().getNodes().get(from), this.getNL().getNodes().get(to), weight, layer);
        }
        this.getNL().repaint();
    }

    public void enableButtons(Boolean enabled) {
        this.buttonadjPval.setEnabled(enabled);
        if (this.getPView().jrbNoCorrelation.isSelected()) {
            this.buttonConfInt.setEnabled(enabled);
        }
        this.buttonStart.setEnabled(enabled);
    }

    public String getGMCPOptions() throws Exception {
        return "," + this.getPView().getPValuesString() + this.correlation + ", alpha=" + this.getPView().getTotalAlpha() + ", eps=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ", verbose=" + (Configuration.getInstance().getGeneralConfig().verbose() ? "TRUE" : "FALSE, callFromGUI=TRUE");
    }

    public DView getDView() {
        return this.parent.getDView();
    }

    public void saveGraphImage(File file) {
        BufferedImage img = this.getNL().getImage(Configuration.getInstance().getGeneralConfig().getExportZoom());
        try {
            ImageIO.write((RenderedImage)img, "png", file);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Saving image to '" + file.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
        }
    }

    public void saveGraph() {
        JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "RObjDirectory"));
        fc.setFileSelectionMode(0);
        fc.setDialogType(1);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".rdata");
            }

            public String getDescription() {
                return "RData files";
            }
        });
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            Configuration.getInstance().setClassProperty(this.getClass(), "RObjDirectory", f.getParent());
            if (!f.getName().toLowerCase().endsWith(".rdata")) {
                f = new File(f.getAbsolutePath() + ".RData");
            }
            try {
                VariableNameDialog vnd = new VariableNameDialog(this.getGraphGUI(), this.getGraphName());
                String name = vnd.getName();
                name = this.getNL().saveGraph(name, false, true);
                String filename = f.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
                RControl.getR().eval("save(" + name + ", file=\"" + filename + "\")");
                JOptionPane.showMessageDialog(this.getMainFrame(), "Exported graph to R object '" + name + "' and saved this to \n'" + f.getAbsolutePath() + "'.", "Saved graph", 1);
                Configuration.getInstance().getGeneralConfig().addGraph(f.getAbsolutePath());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getMainFrame(), "Saving graph to '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed", 0);
            }
        }
    }

    public void loadPValuesFromR() {
        VariableNameDialog vnd = new VariableNameDialog(this.getGraphGUI());
        try {
            double[] data = RControl.getR().eval(vnd.getName()).asRNumeric().getData();
            if (data.length != this.getNL().getNodes().size()) {
                JOptionPane.showMessageDialog(this.getMainFrame(), "Number of hypotheses and values do not match.", "Number of hypotheses and values do not match", 0);
                return;
            }
            this.getPView().setPValues(ArrayUtils.toObject((double[])data));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error loading values from R:\n" + ex.getMessage(), "Error loading values from R", 0);
        }
    }

    public void copyGraphToClipboard() {
        if (OSTools.isLinux() && !Configuration.getInstance().getClassProperty(this.getClass(), "showClipboardInfo", "yes").equals("no")) {
            String message = "An old bug from 2007 that is widely known but never\nfixed from Sun/Oracle in Java will most likely prevent this\nfeature to work on a Linux machine.\nWe are sorry\u2026";
            JCheckBox tellMeAgain = new JCheckBox("Don't show me this info again.");
            JOptionPane.showMessageDialog(this.parent, new Object[]{message, tellMeAgain}, "Will most likely not work under Linux", 2);
            if (tellMeAgain.isSelected()) {
                Configuration.getInstance().setClassProperty(this.getClass(), "showClipboardInfo", "no");
            }
        }
        if (this.getNL().getNodes().size() == 0) {
            JOptionPane.showMessageDialog(this.getMainFrame(), "Graph is empty - nothing copied to clipboard.", "Empty graph", 0);
            return;
        }
        TransferableImage.copyImageToClipboard(this.getNL().getImage(Configuration.getInstance().getGeneralConfig().getExportZoom()));
    }

    public boolean isResultUpToDate() {
        return this.resultUpToDate;
    }

    public void setResultUpToDate(boolean resultUpToDate) {
        this.resultUpToDate = resultUpToDate;
    }

    public void renameNode(Node node, String name) {
        int i = this.getNL().whichNode(node.getName());
        this.parent.getPView().renameNode(i, name);
        this.parent.getDataFramePanel().renameNode(i, name);
        node.setName(name);
    }

    public DataFramePanel getDataFramePanel() {
        return this.parent.dfp;
    }

    public int getNumberOfLayers() {
        return this.getDataFramePanel().getTable().size();
    }

    public void addEntangledLayer() {
        this.getDataFramePanel().addLayer();
        this.getPView().addEntangledLayer();
        this.nl.addEntangledLayer();
    }

    public void removeEntangledLayer(int layer) {
        this.nl.removeLayer(layer);
        this.getPView().removeEntangledLayer(layer);
    }
}

