% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence-func.R
\name{evidence-object}
\alias{as.data.frame.grain_ev}
\alias{evidence-object}
\alias{is.null_ev}
\alias{new_ev}
\alias{print.grain_ev}
\alias{setdiff_ev}
\alias{subset.grain_ev}
\alias{union_ev}
\alias{varNames.grain_ev}
\title{Evidence objects}
\usage{
new_ev(evi.list = NULL, levels)

is.null_ev(object)

\method{print}{grain_ev}(x, ...)

\method{varNames}{grain_ev}(x)

\method{as.data.frame}{grain_ev}(x, row.names = NULL, optional = FALSE, ...)

setdiff_ev(ev1, ev2)

union_ev(ev1, ev2)
}
\arguments{
\item{evi.list}{A named list with evidence; see 'examples' below.}

\item{levels}{A named list with the levels of all variables.}

\item{object}{Some R object.}

\item{x}{Evidence object}

\item{...}{Not used.}

\item{row.names}{Not used.}

\item{optional}{Not used.}

\item{ev1, ev2}{Evidence.}
}
\description{
Functions for defining and manipulating evidence.
}
\details{
Evidence is specified as a list. Internally, evidence is
    represented as a grain evidence object which is a list with 4 elements.
}
\examples{

## Define the universe

uni <- list(asia = c("yes", "no"), tub = c("yes", "no"), smoke = c("yes", "no"),
            lung = c("yes", "no"), bronc = c("yes", "no"), either = c("yes", "no"),
            xray = c("yes", "no"), dysp = c("yes", "no"))

e1 <- list(dysp="no", xray="no")
eo1 <- new_ev( e1, levels=uni )
eo1
as.data.frame( eo1 )
eo1 \%>\% str

e1.2 <- list(dysp="no", xray=c(0, 1))
eo1.2 <- new_ev( e1.2, levels=uni )
eo1.2

# Notice that in \\code{eo1.2}, \\code{xray} is not regarded as hard
# evidence but as a weight on each level. Other than that \\code{eo1.2}
# and \\code{eo1} are equivalent here. This is used in connection
# with specifying likelihood evidence. 

e2 <- list(dysp="yes", asia="yes")
eo2 <- new_ev(e2, uni)

# If evidence 'e1' is already set in the network and new evidence
# 'e2' emerges, the evidence in the network must be updated. But
# there is a conflict in that \\code{dysp="yes"} in 'e1' and
# \\code{dysp="no"} in 'e2'. The (arbitrary) convention is that
# existsting evidence overrides new evidence so that the only new
# evidence in 'e2' is really \\code{asia="yes"}.

# To subtract existing evidence from new evidence we can do:
setdiff_ev( eo2, eo1 )

# Likewise the 'union' is
union_ev( eo2, eo1 )


}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}

