% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grain-compile.R
\name{grain-compile}
\alias{compile.CPTgrain}
\alias{compile.POTgrain}
\alias{compile.grain}
\alias{grain-compile}
\title{Compile a graphical independence network (a Bayesian network)}
\usage{
\method{compile}{grain}(object, propagate = FALSE, root = NULL,
  control = object$control, details = 0, ...)

\method{compile}{CPTgrain}(object, propagate = FALSE, root = NULL,
  control = object$control, details = 0, ...)

\method{compile}{POTgrain}(object, propagate = FALSE, root = NULL,
  control = object$control, details = 0, ...)
}
\arguments{
\item{object}{A grain object.}

\item{propagate}{If TRUE the network is also propagated meaning
that the cliques of the junction tree are calibrated to each
other.}

\item{root}{A set of variables which must be in the root of the
junction tree}

\item{control}{Controlling the compilation process.}

\item{details}{For debugging info. Do not use.}

\item{\dots}{Currently not used.}
}
\value{
A compiled Bayesian network; an object of class
    \code{grain}.
}
\description{
Compiles a Bayesian network. This means creating a
    junction tree and establishing clique potentials.
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\references{
Søren Højsgaard (2012). Graphical Independence
    Networks with the gRain Package for R. Journal of Statistical
    Software, 46(10), 1-26.
    \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{grain}}, \code{\link[gRbase]{propagate}},
    \code{\link[gRbase]{triangulate}}, \code{\link[gRbase]{rip}},
    \code{\link[gRbase]{junctionTree}}
}
\keyword{models}
\keyword{utilities}

