% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_joint.R
\name{grain_joint_evidence}
\alias{grain_joint_evidence}
\alias{setJEvidence}
\alias{print.grain_joint_evidence}
\alias{retractJEvidence}
\alias{new_jev}
\title{Set joint evidence in grain objects}
\usage{
setJEvidence(object, evidence = NULL, propagate = TRUE, details = 0)

retractJEvidence(object, items = NULL, propagate = TRUE, details = 0)

new_jev(ev, levels)
}
\arguments{
\item{object}{A "grain" object.}

\item{evidence}{A list of evidence. Each element is a named array.}

\item{propagate}{Should evidence be absorbed once entered; defaults
to TRUE.}

\item{details}{Amount of printing; for debugging.}

\item{items}{Items in the evidence list to be removed. Here,
\code{NULL} means remove everything, \code{0} means nothing is
removed. Otherwise \code{items} is a numeric vector.}

\item{ev}{A named list.}

\item{levels}{A named list.}
}
\description{
Setting and removing joint evidence in grain objects.
}
\note{
All the joint evidence functionality should be used with
great care.
}
\examples{
data(chest_cpt)
chest.bn <- grain(compileCPT(chest_cpt))
chest.bn <- compile(chest.bn)

uni <- list(asia = c("yes", "no"), tub = c("yes", "no"),
            smoke = c("yes", "no"), lung = c("yes", "no"),
            bronc = c("yes", "no"), either = c("yes", "no"),
            xray = c("yes", "no"), dysp = c("yes", "no"))

ev <- list(tabNew("asia", levels=uni, values=c(1,0)),
           tabNew("dysp", levels=uni, values=c(1,0)),
           tabNew(c("dysp","bronc"), levels=uni, values=c(.1, .2, .9, .8)) )

chest.bn
chest.bn2 <- setJEvidence(chest.bn, evidence=ev)
chest.bn2
getEvidence(chest.bn2)

# Notice: The evidence is defined on (subsets of) cliques of the junction tree
# and therefore evidence can readily be absorbed:
getgrain(chest.bn, "rip")$cliques  \%>\% str

# On the other hand, below is evidence which is not defined cliques
# of the junction tree and therefore evidence can not easily be
# absorbed.  Hence this will fail:

\dontrun{
ev.fail <- list(tabNew(c("dysp","smoke"), levels=uni, values=c(.1, .2, .9, .8)) )
setJEvidence(chest.bn, evidence=ev.fail)
}

## Evidence can be removed with

retractJEvidence(chest.bn2)      ## All evidence removed.
retractJEvidence(chest.bn2, 0)   ## No evidence removed.
retractJEvidence(chest.bn2, 1:2) ## Evidence items 1 and 2 are removed.

# Setting additional joint evidence to an object where joint
# evidence already is set will cause an error. Hence this will fail:

\dontrun{
  ev2 <- list(smoke="yes")
  setJEvidence(chest.bn2, evidence=ev2)
}

## Instead we can do
new.ev <- c(getEvidence(chest.bn2), list(smoke="yes"))
chest.bn
setJEvidence(chest.bn, evidence=new.ev)

## Create joint evidence object:
yn <- c("yes", "no")
db <- tabNew(c("dysp", "bronc"), list(dysp=yn, bronc=yn), values=c(.1, .2, .9, .8))
db
ev   <- list(asia=c(1, 0), dysp="yes", db)

jevi <- new_jev(ev, levels=uni)
jevi

chest.bn3 <- setJEvidence(chest.bn, evidence=jevi)
evidence(chest.bn3)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
