% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-utilities.R
\name{graph-vpar}
\alias{graph-vpar}
\alias{vpar}
\alias{vpar.Matrix}
\alias{vpar.graphNEL}
\alias{vpar.matrix}
\alias{vparMAT}
\title{List of vertices and their parents for graph.}
\usage{
vpar(object, getv = TRUE, forceCheck = TRUE)

vparMAT(object, getv = TRUE, forceCheck = TRUE)

\method{vpar}{graphNEL}(object, getv = TRUE, forceCheck = TRUE)

\method{vpar}{Matrix}(object, getv = TRUE, forceCheck = TRUE)

\method{vpar}{matrix}(object, getv = TRUE, forceCheck = TRUE)
}
\arguments{
\item{object}{An object representing a graph. Valid objects are an
adjacency matrix or as a graphNEL.}

\item{getv}{The result is by default a list of vectors of the form
\code{(v, pa1, pa2, ... paN)} where \code{pa1, pa2, ... paN}
are the parents of \code{v}. If \code{getv} is \code{FALSE}
then the vectors will have the form \code{(pa1, pa2, ... paN)}}

\item{forceCheck}{Logical indicating if it should be checked that
the object is a DAG.}
}
\value{
A list of vectors where each vector will have the form
    \code{(v, pa1, pa2, ... paN)} where \code{pa1, pa2, ... paN}
    are the parents of \code{v}.
}
\description{
Get list of vertices and their parents for graph.
}
\examples{

## DAGs
dagMAT <- dag(~a:b:c+c:d:e, result="matrix")
dagNEL <- dag(~a:b:c+c:d:e, result="NEL")
vpar(dagMAT)
vpar(dagNEL)
vpar(dagMAT, getv=FALSE)
vpar(dagNEL, getv=FALSE)
## Undirected graphs
ugMAT <- ug(~a:b:c+c:d:e, result="matrix")
ugNEL <- ug(~a:b:c+c:d:e, result="NEL")
\dontrun{
## This will fail because the adjacency matrix is symmetric and the
## graphNEL has undirected edges
vpar(ugMAT)
vpar(ugNEL)
}
## When forceCheck is FALSE, it will not be detected that the graphs are undirected.
vpar(ugMAT, forceCheck=FALSE)
vpar(ugNEL, forceCheck=FALSE)
## Bidirected graphs
## This is, for graphNELs, the same as working with bidirected edges:
if (require(graph)){
graph::edgemode(ugNEL)
graph::edgemode(ugNEL) <- "directed"
graph::edgemode(ugNEL)
vpar(ugNEL,FALSE)
}
}
\seealso{
\code{\link{dag}}, \code{\link{ug}}
}

