% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array-parray.R
\name{array-parray}
\alias{array-parray}
\alias{parray}
\alias{as.parray}
\alias{data2parray}
\title{Representation of and operations on multidimensional arrays}
\usage{
parray(varNames, levels, values = 1, normalize = "none", smooth = 0)

as.parray(values, normalize = "none", smooth = 0)
}
\arguments{
\item{varNames}{Names of variables defining table; can be a right hand sided
formula.}

\item{levels}{Either 1) a vector with number of levels of the factors in
varNames or 2) a list with specification of the levels of the factors in
varNames. See 'examples' below.}

\item{values}{Values to go into the array}

\item{normalize}{Either "none", "first" or "all". Should result be
normalized, see 'Details' below.}

\item{smooth}{Should values be smoothed, see 'Details' below.}
}
\value{
A a named array.
}
\description{
General representation of multidimensional arrays (with named
    dimnames, also called named arrays.)
}
\details{
A named array object represents a table defined by a set of variables and
their levels, together with the values of the table. E.g. f(a,b,c) can be a
table with a,b,c representing levels of binary variable

If \code{normalize="first"} then for each configuration of all other
variables than the first, the probabilities are normalized to sum to one.
Thus f(a,b,c) becomes a conditional probability table of the form p(a|b,c).
If \code{normalize="all"} then the sum over all entries of f(a,b,c) is one.

If \code{smooth} is positive then \code{smooth} is added to \code{values}
before normalization takes place.
}
\examples{
 
t1 <- parray(c("gender","answer"), list(c('male','female'),c('yes','no')), values=1:4)
t1 <- parray(~gender:answer, list(c('male','female'),c('yes','no')), values=1:4)
t1 <- parray(~gender:answer, c(2,2), values=1:4)

t2 <- parray(c("answer","category"), list(c('yes','no'),c(1,2)), values=1:4+10)
t3 <- parray(c("category","foo"), c(2,2), values=1:4+100)

varNames(t1)
nLevels(t1)
valueLabels(t1)

## Create 1-dimensional vector with dim and dimnames
x1 <- 1:5
as.parray(x1)
x2 <- parray("x", levels=length(x1), values=x1)
dim(x2)
dimnames(x2)

## Matrix
x1 <- matrix(1:6, nrow=2)
as.parray(x1)
parray(~a:b, levels=dim(x1), values=x1)

## Extract parrays from data
## 1) a dataframe
data(cad1) 
data2parray(cad1, ~Sex:AngPec:AMI)
data2parray(cad1, c("Sex","AngPec","AMI"))
data2parray(cad1, c(1,2,3))
## 2) a table
data2parray(UCBAdmissions,c(1,2), normalize="first")

}
\seealso{
\code{\link{is.named.array}}, \code{\link{ar_marg}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
