% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciTest.R
\name{ciTest_mvn}
\alias{ciTest_mvn}
\title{Test for conditional independence in the multivariate normal distribution}
\usage{
ciTest_mvn(x, set = NULL, statistic = "DEV", ...)
}
\arguments{
\item{x}{A list with elements \code{cov} and \code{n.obs} (such as returned
from calling \code{cov.wt()} on a dataframe. See examples below.)}

\item{set}{A specification of the test to be made. The tests are of the form
u and v are independent condionally on S where u and v are variables and
S is a set of variables. See 'details' for details about specification of
\code{set}.}

\item{statistic}{The test statistic to be used, valid choices are
\code{"DEV"} and \code{"F"}.}

\item{\dots}{Additional arguments}
}
\value{
An object of class 'citest' (which is a list).
}
\description{
Test for conditional independence in the multivariate normal distribution.
}
\details{
\code{set} can be 1) a vector or 2) a right-hand sided formula in which
variables are separated by '+'. In either case, it is tested if the first
two variables in the \code{set} are conditionally independent given the
remaining variables in \code{set}.  (Notice an abuse of the '+' operator in
the right-hand sided formula: The order of the variables does matter.)

If \code{set} is \code{NULL} then it is tested whether the first two
variables are conditionally independent given the remaining variables.

\code{x} must be a list with components \code{cov} and \code{n.obs} such as
returned by calling \code{cov.wt( , method='ML')} on a dataframe.
}
\examples{

data(carcass)
ciTest(cov.wt(carcass, method='ML'), set=~Fat11+Meat11+Fat12)
ciTest_mvn(cov.wt(carcass, method='ML'), set=~Fat11+Meat11+Fat12)

}
\seealso{
\code{\link{ciTest}} \code{\link{ciTest.table}},
    \code{\link{ciTest_table}}, \code{\link{ciTest.data.frame}},
    \code{\link{ciTest_df}}, \code{\link{ciTest.list}},
    \code{\link{ciTest_mvn}}, \code{\link{chisq.test}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
