# Build a data request object
data_request <- function(taxa = NULL, filters = NULL, locations = NULL,
                      columns = NULL, ...){
  
  extra_args <- list(...)
  
  if(!is.null(taxa)) {
    check_taxa_arg(taxa)
  }
  if(!is.null(filters) && !any(grepl("ala_filters", class(filters)))){
    stop("`filters` argument requires an input generated by `select_filters()`")
  }
  if(!is.null(locations) && !any(grepl("ala_locations", class(locations)))){
    stop("`locations` argument requires an input generated by `select_locations()`")
  }
  if(!is.null(columns) && !any(grepl("ala_columns", class(columns)))){
    stop("`columns` argument requires an input generated by `select_columns()`")
  }
  
  request <- structure(c(list(taxa = taxa, 
                          filters = filters,
                          locations = locations,
                          columns = columns), extra_args),
                       class = "data_request")
  
  return(request)
}
