% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_taxa.R
\name{search_taxa}
\alias{search_taxa}
\title{Taxon information}
\usage{
search_taxa(...)
}
\arguments{
\item{...}{: One or more scientific names, separated by commas and
given as strings. If greater control is required to disambiguate search
terms, taxonomic levels can be provided explicitly via a \code{data.frame}
(see examples). Note that searches are not case-sensitive.}
}
\value{
An object of class \code{tbl_df}, \code{data.frame} (aka a tibble) and \code{ala_id}
containing taxonomic information.
}
\description{
In the ALA, all records are associated with an identifier that uniquely
identifies the taxon to which that record belongs. However, taxonomic names
are often ambiguous due to homonymy; i.e. re-use of names (common or
scientific) in different clades. Hence, \code{search_taxa} provides a means
to search for taxonomic names and check the results are 'correct' before
proceeding to download data via
\code{\link[=atlas_occurrences]{atlas_occurrences()}}, \code{\link[=atlas_species]{atlas_species()}} or \code{\link[=atlas_counts]{atlas_counts()}}. The resulting
\code{data.frame} of taxonomic information can be passed to \code{\link[=galah_identify]{galah_identify()}} to
provide the \code{identify} argument of \code{atlas_} functions, which then filters
the resulting records to the specified taxon or taxa.
}
\section{Examples}{


Search using a single term\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_taxa("Reptilia")
#> # A tibble: 1 x 9
#>   search_term scientific_name taxon_concept_id                              rank  match_type kingdom  phylum  class  issues
#>   <chr>       <chr>           <chr>                                         <chr> <chr>      <chr>    <chr>   <chr>  <chr> 
#> 1 Reptilia    REPTILIA        urn:lsid:biodiversity.org.au:afd.taxon:682e1~ class exactMatch Animalia Chorda~ Repti~ noIss~
}\if{html}{\out{</div>}}

Note that \code{search_taxa()} is not case sensitive\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_taxa("reptilia") # not case sensitive
#> # A tibble: 1 x 9
#>   search_term scientific_name taxon_concept_id                              rank  match_type kingdom  phylum  class  issues
#>   <chr>       <chr>           <chr>                                         <chr> <chr>      <chr>    <chr>   <chr>  <chr> 
#> 1 reptilia    REPTILIA        urn:lsid:biodiversity.org.au:afd.taxon:682e1~ class exactMatch Animalia Chorda~ Repti~ noIss~
}\if{html}{\out{</div>}}

Search multiple taxa. \code{search_taxa()} will return one row per taxon\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_taxa(c("reptilia", "mammalia"))
#> # A tibble: 2 x 10
#>   search_term scientific_name taxon_concept_id                rank  match_type kingdom  phylum class issues vernacular_name
#>   <chr>       <chr>           <chr>                           <chr> <chr>      <chr>    <chr>  <chr> <chr>  <chr>          
#> 1 reptilia    REPTILIA        urn:lsid:biodiversity.org.au:a~ class exactMatch Animalia Chord~ Rept~ noIss~ <NA>           
#> 2 mammalia    MAMMALIA        urn:lsid:biodiversity.org.au:a~ class exactMatch Animalia Chord~ Mamm~ noIss~ Mammals
}\if{html}{\out{</div>}}

\code{galah_identify()} uses \code{search_taxa()} to narrow data queries\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
  galah_identify("reptilia") |>
  atlas_counts()
#> # A tibble: 1 x 1
#>     count
#>     <int>
#> 1 1317131
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=search_identifiers]{search_identifiers()}} for how to get names if taxonomic identifiers
are already known. \code{\link[=galah_identify]{galah_identify()}}, \code{\link[=galah_select]{galah_select()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_geolocate]{galah_geolocate()}} for ways to restrict the information returned
by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions.
\code{\link[=atlas_taxonomy]{atlas_taxonomy()}} to look up taxonomic trees.
}
