% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_fields.R, R/show_all_fields.R
\name{search_fields}
\alias{search_fields}
\alias{show_all_fields}
\title{Query layers, fields or assertions by free text search}
\usage{
search_fields(
  query,
  type = c("all", "fields", "layers", "assertions", "media", "other")
)

show_all_fields(
  type = c("all", "fields", "layers", "assertions", "media", "other")
)
}
\arguments{
\item{query}{\code{string}: A search string. Not case sensitive.}

\item{type}{\code{string}: What type of parameters should be searched?
Should be one or more of \code{fields}, \code{layers}, \code{assertions},
\code{media} or \code{all}.}
}
\value{
if \code{query} is missing, an empty \code{data.frame}; otherwise
an object of class \code{tbl_df} and \code{data.frame} (aka a tibble) containing
fields that match the search query.

An object of class \code{tbl_df} and \code{data.frame} (aka a tibble) with
three columns:
\itemize{
\item id: The identifier for that layer or field. This is the value that should
be used when referring to a field in another function.
\item description: Detailed information on a given field
\item type: Whether the field is a \code{field} or \code{layer}
\item link: For layers, a link to the source data (if available)
}
}
\description{
This function can be used to find relevant fields and/or layers
for use in building a set of filters with \code{\link[=galah_filter]{galah_filter()}} or
specifying required columns with \code{\link[=galah_select]{galah_select()}}.
This function returns a \code{data.frame} of all fields matching the type
specified.
Field names are in Darwin Core format, except in the case where the field is
specific to the ALA database, in which case the ALA field name is returned.
}
\details{
Layers are the subset of fields that are spatially appended to each record
by the ALA. Layer ids are comprised of a prefix: 'el' for environmental
(gridded) layers and 'cl' for contextual (polygon) layers,  followed by an
id number.
}
\section{Examples}{


Search for all fields that use include the word "date"\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_fields("date")
#> # A tibble: 33 x 4
#>   id             description     type   link 
#>   <chr>          <chr>           <chr>  <chr>
#> 1 dateIdentified Date Identified fields <NA> 
#> 2 datePrecision  Date precision  fields <NA> 
#> 3 eventDate      Event Date      fields <NA> 
#> 4 eventDateEnd   <NA>            fields <NA> 
#> # ... with 29 more rows
}\if{html}{\out{</div>}}

Search for all fields with the string "basisofrecord"\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_fields("basisofrecord")
#> # A tibble: 2 x 4
#>   id                description               type   link 
#>   <chr>             <chr>                     <chr>  <chr>
#> 1 basisOfRecord     Record type               fields <NA> 
#> 2 raw_basisOfRecord Record type (unprocessed) fields <NA>
}\if{html}{\out{</div>}}

Search for all fields that have information for "marine"\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_fields("marine") |> 
  head() # only show first 5 results
#> # A tibble: 6 x 4
#>   id      description                                             type   link                                              
#>   <chr>   <chr>                                                   <chr>  <chr>                                             
#> 1 cl2105  "FAO Fishery Statistical Areas FAO Fishing areas (Mari~ layers "http://www.fao.org/geonetwork/srv/en/main.home?u~
#> 2 cl10948 "CAPAD 2018 Terrestrial The Collaborative Australian P~ layers "http://www.environment.gov.au/fed/catalog/search~
#> 3 cl10957 "CAPAD 2018 Marine The Collaborative Australian Protec~ layers "http://www.environment.gov.au/fed/catalog/search~
#> 4 el1056  "Endemism (Non-marine) Endemism (Non-marine) based on ~ layers ""                                                
#> 5 el957   "Averaged Topographic Relief  This data represents the~ layers "http://www.ga.gov.au/meta/ANZCW0703015076.html"  
#> 6 cl11033 "CAPAD 2020 Terrestrial The Collaborative Australian P~ layers "http://www.environment.gov.au/fed/catalog/search~
}\if{html}{\out{</div>}}

Search for all Wordclim layers\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_fields("worldclim", type = "layers")
#> # A tibble: 38 x 4
#>   id      description                                                                     type   link                      
#>   <chr>   <chr>                                                                           <chr>  <chr>                     
#> 1 el10982 WorldClim 2.1: Temperature - warmest month max Max Temperature of Warmest Month layers https://www.worldclim.org~
#> 2 el10981 WorldClim 2.1: Temperature - seasonality Temperature Seasonality                layers https://www.worldclim.org~
#> 3 el10980 WorldClim 2.1: Temperature - isothermality Isothermality                        layers https://www.worldclim.org~
#> 4 el10990 WorldClim 2.1: Precipitation - wettest month Precipitation of Wettest Month     layers https://www.worldclim.org~
#> # ... with 34 more rows
}\if{html}{\out{</div>}}



See a listing of all valid fields and layers\if{html}{\out{<div class="sourceCode r">}}\preformatted{show_all_fields()
#> # A tibble: 790 x 4
#>   id                  description        type   link 
#>   <chr>               <chr>              <chr>  <chr>
#> 1 acceptedNameUsage   Accepted name      fields <NA> 
#> 2 acceptedNameUsageID Accepted name      fields <NA> 
#> 3 accessRights        Access rights      fields <NA> 
#> 4 assertionUserId     Assertions by user fields <NA> 
#> # ... with 786 more rows
}\if{html}{\out{</div>}}

Use this function with \code{\link[=search_fields]{search_fields()}} to find fields and layers you wish
to use to filter your data queries
}

\references{
\itemize{
\item Darwin Core terms \url{https://dwc.tdwg.org/terms/}
\item ALA fields \url{https://api.ala.org.au/#ws72}
\item ALA assertions fields \url{https://api.ala.org.au/#ws81}
}
}
\seealso{
This function is used to pass valid arguments to
\code{\link[=galah_select]{galah_select()}} and \code{\link[=galah_filter]{galah_filter()}}.
To view valid values for a layer with categorical values, use
\code{\link[=search_field_values]{search_field_values()}}.
}
