% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_polygon.R
\name{galah_polygon}
\alias{galah_polygon}
\title{Narrow a query to within a specified polygon}
\usage{
galah_polygon(...)
}
\arguments{
\item{...}{a single \code{sf} object, WKT string or shapefile.}
}
\value{
length-1 object of class \code{character} and \code{galah_geolocate},
containing a multipolygon WKT string representing the area provided.
}
\description{
Restrict results to those from a specified area. Areas must be polygons.
Polygons must be supplied as an \code{sf} object, a 'well-known text' (WKT)
string, or a shapefile. Polygons and shapefiles must not be overly complex
(i.e. have too many characters or too many vertices) or they will not be
accepted in a query to the ALA.
}
\details{
WKT strings longer than 10000 characters and
\code{sf} objects with more than 500 vertices will not be
accepted by the ALA. Some polygons  may need to be simplified.
}
\examples{
# Search for records within a polygon using an `sf` object
location <- 
"POLYGON((143.32 -18.78,145.30 -20.52,141.52 -21.50,143.32 -18.78))" |>
 sf::st_as_sfc()
galah_call() |>
  galah_identify("reptilia") |>
  galah_polygon(location) |>
  atlas_counts()
\dontrun{
# Search for records using a shapefile
galah_config(email = "your_email_here")
location <- galah_geolocate(sf::st_read(path/to/shapefile.shp))
galah_call() |>
  galah_identify("vulpes") |>
  galah_polygon(location) |>
  atlas_occurrences()
}
# Search for records using a Well-known Text string (WKT)
wkt <- "POLYGON((142.36228 -29.00703,
                 142.74131 -29.00703,
                 142.74131 -29.39064,
                 142.36228 -29.39064,
                 142.36228 -29.00703))"
galah_call() |>
  galah_identify("vulpes") |>
  galah_polygon(wkt) |>
  atlas_counts()

}
\seealso{
\code{\link[=galah_bbox]{galah_bbox()}} & \code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to narrow
queries by location. \code{\link[=search_taxa]{search_taxa()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_select]{galah_select()}} for other ways to restrict the information
returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions.
}
\keyword{internal}
