\name{print.gama}
\alias{print.gama}
\title{Prints results of a Gama clustering.}
\description{
  This function takes a gama object and prints:

  \enumerate{
    \item a sample of the original dataset used for clustering;
    \item the cluster solution (partitions);
    \item the centers of partitions;
    \item the indices Average Silhouette Width (ASW), Calinski Harabasz (CH), C-Index (CI), Dunn index (DI).
  }

}
\usage{
 \method{print}{gama}(x, \dots)
}
\arguments{
  \item{x}{an object of type 'gama' generated by an appropriate call to the clustering algorithm.}
  \item{\dots}{other arguments that user may pass to the function.}

}
\seealso{
  \code{\link{gama}, \link{gama.plot.partitions}}.
}

\examples{
\dontrun{
  # loads data about CPU execution metrics of a distributed
  # version of Alternating Least Squares (ALS) algorithm
  data(cpu.als)

  # call the gama clustering algorithm
  gamaObj <- gama(cpu.als, k = 4)

  # call the print.gama function to detail the clustering results
  # note: print.gama uses generic function concept, which allows a call to print, only.
  print(gamaObj)

  }
}
\keyword{file}
