% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{Exclude}
\alias{Exclude}
\alias{Exclude,ANY-method}
\title{Exclude}
\usage{
Exclude(object, ..., scope)

\S4method{Exclude}{ANY}(object, ..., scope)
}
\arguments{
\item{object}{A segment condition or sequence filter to include.}

\item{...}{Additional segment conditions to include.}

\item{scope}{Optional scope, \code{"users"} or \code{"sessions"} (default).}
}
\value{
A \code{.gaSegmentFilter} object with its negate slot set to
\code{TRUE}.
}
\description{
Set the negation flag of a segment filter to \code{TRUE}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Define an exclude segment filter using the supplied
expressions.
}}

\examples{
exclude_one_time_shoppers <- Exclude(
  Expr(~transactions == 1, metricScope = "perUser"),
  scope = "users"
)

}
\seealso{
Other dynamic segment functions: \code{\link{DynSegment}},
  \code{\link{Include}}, \code{\link{IsNegated}},
  \code{\link{PerHit}}, \code{\link{PerProduct}},
  \code{\link{PerSession}}, \code{\link{PerUser}},
  \code{\link{ScopeLevel}},
  \code{\link{SegmentConditionFilter}},
  \code{\link{Segments}}, \code{\link{Segment}}
}
\concept{dynamic segment functions}
