% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr.R
\name{mr}
\alias{mr}
\title{Mendelian randomization analysis}
\usage{
mr(data, X, Y, alpha = 0.05, other_plots = FALSE)
}
\arguments{
\item{data}{Data to be used.}

\item{X}{Exposure.}

\item{Y}{Outcome.}

\item{alpha}{type I error rate for confidence intervals.}

\item{other_plots}{To add funnel and forest plots.}
}
\value{
The result and plots.
}
\description{
The function initially intends to rework on GSMR outputs, but it would be appropriate for general use.
}
\examples{
library(ggplot2)
library(gap)
mrdat <- '
 rs188743906  0.6804   0.1104  0.00177 0.01660        NA        NA
   rs2289779 -0.0788   0.0134  0.00104 0.00261 -0.007543 0.0092258
 rs117804300 -0.2281   0.0390 -0.00392 0.00855  0.109372 0.0362219
   rs7033492 -0.0968   0.0147 -0.00585 0.00269  0.022793 0.0119903
  rs10793962  0.2098   0.0212  0.00378 0.00536 -0.014567 0.0138196
    rs635634 -0.2885   0.0153 -0.02040 0.00334  0.077157 0.0117123
    rs176690 -0.0973   0.0142  0.00293 0.00306 -0.000007 0.0107781
 rs147278971 -0.2336   0.0378 -0.01240 0.00792  0.079873 0.0397491
  rs11562629  0.1155   0.0181  0.00960 0.00378 -0.010040 0.0151460
'
v <- c("SNP", "b.LIF.R", "SE.LIF.R", "b.FEV1", "SE.FEV1", "b.CAD", "SE.CAD")
mrdat <- setNames(as.data.frame(scan(file=textConnection(mrdat),
                                     what=list("",0,0,0,0,0,0))), v)
knitr::kable(mrdat,caption="Table 2. LIF.R and CAD/FEV1")
res <- mr(mrdat, "LIF.R", c("CAD","FEV1"), other_plots=TRUE)
s <- res$r[-1,]
colnames(s) <- res$r[1,]
r <- matrix(as.numeric(s[,-1]),nrow(s),dimnames=list(res$r[-1,1],res$r[1,-1]))
p <- sapply(c("IVW","EGGER","WM","PWM"), function(x)
     format(2*pnorm(-abs(r[,paste0("b",x)]/r[,paste0("seb",x)])),digits=3,scientific=TRUE))
rp <- t(data.frame(round(r,3),p))
knitr::kable(rp,align="r",caption="Table 3. LIFR variant rs635634 and CAD/FEV1")
}
