% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_distr.R
\name{distr_random}
\alias{distr_random}
\title{Generate Random Observations}
\usage{
distr_random(t, f, distr, param = NULL, par_link = NULL)
}
\arguments{
\item{t}{A number of generated observations.}

\item{f}{A numeric vector of parameters. The same parameters are used for each generated observation.}

\item{distr}{A distribution.}

\item{param}{A parametrization of the distribution.}

\item{par_link}{An optional logical vector indicating whether the logarithmic/logistic link should be applied to restricted parameters in order to obtain unrestricted values. Defaults to keeping the original link for all parameters.}
}
\value{
The generated observations.
}
\description{
A function generating random observations from a given distribution.
}
\examples{
# Random observations from the negative binomial distribution
distr_random(t = 10, f = c(0.5, 1.2), distr = "negbin")

# Random observations from the multivariate normal distribution
distr_random(t = 10, f = c(0, 0, 1, 1, 0.5), distr = "mvnorm")

}
\seealso{
\code{\link[gasmodel:distr]{distr()}}
}
