% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency_mat.R
\name{adjacency_mat}
\alias{adjacency_mat}
\title{Compute the adjacency matrix of the gaussian weighted graph}
\usage{
adjacency_mat(pts, f = function(x) {     exp(-x^2/8) }, s = 0)
}
\arguments{
\item{pts}{coordinates of N points in \eqn{R^3}{R^3}.}

\item{f}{is a scalar potential (\eqn{\exp(-x^2/2t^2)}{exp(-x^2/2*t^2)} for gaussian potential)}

\item{s}{is a threhold to sparisfy the matrix}
}
\description{
Compute the adjacency matrix of the gaussian weighted graph
}
\examples{
pts <- swissroll(N=100, seed=0, a=1, b=4)
W <- adjacency_mat(pts)
}
\seealso{
\code{\link{laplacian_mat}}
}
