\name{bed.loadings}
\alias{bed.loadings}

\title{ SNP loadings }

\description{ Compute the loadings corresponding to given PCs. }
\usage{ bed.loadings(x, pc) }

\arguments{
  \item{x}{ A \code{\link{bed.matrix}} }
  \item{pc}{ A matrix with Principal Components in columns }
}

\value{ A matrix with the corresponding loadings in columns. }

\author{ Hervé Perdry and Claire Dandine-Roulland }

\examples{
# Temporarily set nb threads to 2 to comply with CRAN rules
n.threads <- getNumThreads()
setThreadOptions(2)

# load chr2 data set (~10k SNPs in low LD)
x <- read.bed.matrix( system.file("extdata", "chr2.bed", package="gaston") )

# Compute Genetic Relationship Matrix
standardize(x) <- "p"
K <- GRM(x)

# Eigen decomposition
eiK <- eigen(K)
# deal with small negative eigen values
eiK$values[ eiK$values < 0 ] <- 0

# Note: the eigenvectors are normalized, to compute 'true' PCs
# multiply them by the square root of the associated eigenvalues
PC <- sweep(eiK$vectors, 2, sqrt(eiK$values), "*")

# Compute loadings for the 2 first PCs 
# one can use PC[,1:2] instead of eiK$vectors[,1:2] as well
L <- bed.loadings(x, eiK$vectors[,1:2])
dim(L)
head(L)

# the loadings are normalized
colSums(L**2)

# Verify that these are loadings
head( (x \%*\% L) / sqrt(ncol(x)-1) )
head( PC[,1:2] )

## back to previous nb threads value
setThreadOptions(n.threads)
}

\keyword{ loadings }
