% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paper_cloud.R
\name{title_cloud}
\alias{title_cloud}
\alias{paper_cloud}
\alias{title_word_frequency}
\title{Make Wordcloud of Titles from Papers}
\usage{
title_cloud(titles, addstopwords = gcite_stopwords(), ...)

paper_cloud(...)

title_word_frequency(titles, addstopwords = NULL)
}
\arguments{
\item{titles}{Vector of titles of papers}

\item{addstopwords}{Additional words to remove from wordcloud}

\item{...}{additional options passed to \code{\link{gcite_wordcloud_spec}}}
}
\value{
A \code{data.frame} of the words and the frequencies of the
title words
}
\description{
Takes a vector of titles and then creates a frequency table
of those words and plots a wordcloud
}
\examples{
\dontrun{
L = gcite_author_info("John Muschelli")
paper_df = L$paper_df
titles = paper_df$title
title_cloud(titles)
}
}
