% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcite_user_info.R
\name{gcite_user_info}
\alias{gcite_user_info}
\title{Getting User Information of papers}
\usage{
gcite_user_info(user, pagesize = 100, verbose = TRUE, secure = TRUE,
  force = FALSE, read_citations = TRUE, sleeptime = 0, ...)
}
\arguments{
\item{user}{user ID for google Citations}

\item{pagesize}{Size of pages, max 100, passed to \code{\link{gcite_url}}}

\item{verbose}{Print diagnostic messages}

\item{secure}{use https vs. http}

\item{force}{If passing a URL and there is a failure, should the 
program return \code{NULL}, passed to \code{\link{gcite_citation_page}}}

\item{read_citations}{Should all citation pages be read?}

\item{sleeptime}{time in seconds between http requests, 
to avoid Google Scholar rate limit}

\item{...}{Additional arguments passed to \code{\link{GET}}}
}
\value{
A list of citations, citation indices, and a 
\code{data.frame} of authors, journal, and citations, and a 
\code{data.frame} of the links to all paper URLs and the character
string of the user name.
}
\description{
Loops through pages for all information on Google Citations
}
\examples{
\dontrun{
if (!is_travis()) {
df = gcite_user_info(user = "uERvKpYAAAAJ")
}
}
}
