\name{gdalsrsinfo}
\alias{gdalsrsinfo}
\title{gdalsrsinfo}
\usage{
gdalsrsinfo(srs_def, p, V, o, additional_commands, as.CRS = FALSE,
  verbose = FALSE)
}
\arguments{
  \item{srs_def}{Character. A raster dataset name. It can
  be either file name.}

  \item{p}{Logical. Pretty-print where applicable (e.g.
  WKT).}

  \item{V}{Logical. Validate SRS.}

  \item{o}{Character. Output type
  ("default"|"all"|"wkt_all"|"proj4"|"wkt"|"wkt_simple"|"wkt_noct"|"wkt_esri"|"mapinfo"|"xml")}

  \item{as.CRS}{Logical. Return a CRS object?
  Default=FALSE.}

  \item{additional_commands}{Character. Additional commands
  to pass directly to gdalsrsinfo.}

  \item{verbose}{Logical.}
}
\value{
character
}
\description{
R wrapper for gdalsrsinfo: lists info about a given SRS in
number of formats (WKT, PROJ.4, etc.)
}
\details{
This is an R wrapper for the 'gdalsrsinfo' function that is
part of the Geospatial Data Abstraction Library (GDAL).  It
follows the parameter naming conventions of the original
function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single
character string following, precisely, the gdalinfo format
(\url{http://www.gdal.org/gdalsrsinfo.html}), or, in some
cases, can use R vectors to achieve the same end.

This function assumes the user has a working GDAL on their
system.  If the "gdalUtils_gdalPath" option has been set
(usually by gdal_setInstallation), the GDAL found in that
path will be used.  If nothing is found,
gdal_setInstallation will be executed to attempt to find a
working GDAL.

If as.CRS is set to TRUE, 'o' will automatically be set to
"proj4" and the output will be coerced to a CRS object for
use with sp.
}
\examples{
\dontrun{
src_dataset <- system.file("external/tahoe_highrez.tif", package="gdalUtils")
# Command-line gdalsrsinfo call:
# gdalsrsinfo -o proj4 tahoe_highrez.tif
gdalsrsinfo(src_dataset,o="proj4")
# Export as CRS:
gdalsrsinfo(src_dataset,as.CRS=TRUE)
}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) and
Matteo Mattiuzzi (wrapper) and Frank Warmerdam (GDAL lead
developer).
}
\references{
\url{http://www.gdal.org/gdalinfo.html}
}

