% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stac.R
\name{stac_image_collection}
\alias{stac_image_collection}
\title{Create an image collection from a STAC feature collection}
\usage{
stac_image_collection(
  s,
  out_file = tempfile(fileext = ".db"),
  asset_names = NULL,
  asset_regex = NULL,
  url_fun = .default_url_fun,
  property_filter = NULL,
  skip_image_metadata = FALSE,
  srs = NULL,
  srs_overwrite = FALSE,
  duration = c("center", "start")
)
}
\arguments{
\item{s}{STAC feature collection}

\item{out_file}{optional name of the output SQLite database file, defaults to a temporary file}

\item{asset_names}{character vector with names of assets (e.g., bands) to be used, other assets will be ignored. By default (NULL), all asset names with "eo:bands" attributes will be used}

\item{asset_regex}{length 1 character defining a regular expression asset names must match to be considered}

\item{url_fun}{optional function to modify URLs of assets, e.g, to add /vsicurl/ to URLS (the default)}

\item{property_filter}{optional function to filter STAC items (images) by their properties; see Details}

\item{skip_image_metadata}{logical, if TRUE per-image metadata (STAC item properties) will not be added to the image collection}

\item{srs}{character spatial reference system of images used either for images without corresponding STAC property ony or for all images}

\item{srs_overwrite}{logical, if FALSE, use srs only for images with unknown srs (missing STAC metadata)}

\item{duration}{character, if images represent time intervals, use either the"start" or "center" of time intervals}
}
\description{
This function creates an image collection from a STAC API collection response. It does not
need to read any image data. Additionally, bands can be filtered and asset links can be transformed to make them
readable for GDAL.
}
\details{
The property_filter argument can be used to filter images by metadata such as cloud coverage. 
The functions receives all properties of a STAC item (image) as input list and is expected to produce a single logical value,
where an image will be ignored if the function returns FALSE.

Some STAC API endpoints may return items with duplicte IDs (image names), pointing to 
identical URLs. Such items are only added once during creation of the image collection.
}
\note{
Currently, bbox results are expected to be WGS84 coordinates, even if bbox-crs is given in the STAC response.
}
