% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdm.single.crossvalidation.R
\name{gdm.single.crossvalidation}
\alias{gdm.single.crossvalidation}
\title{Single GDM Cross-Validation Test, Internal Function}
\usage{
gdm.single.crossvalidation(spTable_train, spTable_test, geo=FALSE,
splines=NULL, knots=NULL)
}
\arguments{
\item{spTable_train}{(dataframe) A dataframe holding the GDM input table for
model fitting.}

\item{spTable_test}{(dataframe) A dataframe holding the GDM input table for
model testing, having identical column names to 'spTable_train' but using
different site-pairs.}

\item{geo}{(boolean) Geographic distance to be used in model fitting
(default = FALSE).}

\item{splines}{(vector) An optional vector of the number of I-spline basis
functions to be used for each predictor in fitting the model.}

\item{knots}{(vector) An optional vector of knots in units of the predictor
variables to be used in the fitting process.}
}
\value{
List, providing cross-validation statistics. These are metrics that
describe how well the model fit using the sitepair training table predicts
the dissimilarities in the sitepair testing table. Metrics provided include:
'Deviance.Explained' (the deviance explained for the training data);
'Test.Deviance.Explained' (the deviance explained for the test data);
'Mean.Error';
'Mean.Absolute.Error';
'Root.Mean.Squre.Error';
'Obs.Pred.Correlation' (Pearson's correlation coefficient between observed and predicted values);
'Equalised.RMSE' (the average root mean square error across bands of observed dissimilarities (0.05 dissimialrity units));
'Error.by.Observed.Value' (the average root mean square error and number of observations within bands of observed dissimilarities (0.05 dissimialrity units)).
}
\description{
Undertake a cross-validation assessment of a GDM, using a single
training and testing dataset.
}
\keyword{gdm}
\keyword{internal}
