% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgd.R
\name{rgd}
\alias{rgd}
\title{robust geographical detector(RGD) model}
\usage{
rgd(
  formula,
  data,
  discvar = NULL,
  discnum = 10,
  minsize = 1,
  cores = 1,
  type = "factor",
  alpha = 0.95
)
}
\arguments{
\item{formula}{A formula of RGD model.}

\item{data}{A data.frame, tibble or sf object of observation data.}

\item{discvar}{Name of continuous variable columns that need to be discretized. Noted that
when \code{formula} has \code{discvar}, \code{data} must have these columns. By default, all independent
variables are used as \code{discvar}.}

\item{discnum}{A numeric vector of discretized classes of columns that need to be discretized.
Default all \code{discvar} use \code{10}.}

\item{minsize}{(optional) The min size of each discretization group. Default all use \code{1}.}

\item{cores}{(optional) Positive integer(default is 1). If cores > 1, use \code{python} \code{joblib} package to
parallel computation.}

\item{type}{(optional) The type of geographical detector, which must be \code{factor}(default),
\code{interaction}, \code{risk}, \code{ecological}.You can run one or more types at one time.}

\item{alpha}{(optional) Specifies the size of confidence level. Default is \code{0.95}.}
}
\value{
A list of the RGD model result.
\describe{
\item{\code{factor}}{the result of factor detector}
\item{\code{interaction}}{the result of interaction detector}
\item{\code{risk}}{the result of risk detector}
\item{\code{ecological}}{the result of ecological detector}
}
}
\description{
Function for robust geographical detector(RGD) model.
}
\note{
Please set up python dependence and configure \code{GDVERSE_PYTHON} environment variable if you want to run \code{rgd()}.
See \code{vignette('rgdrid',package = 'gdverse')} for more details.
}
\examples{
\dontrun{
## The following code needs to configure the Python environment to run:
data('ndvi')
g = rgd(NDVIchange ~ ., data = ndvi, discvar = names(ndvi)[-1:-3],
        cores = 6, type =c('factor','interaction'))
}
}
\references{
Zhang, Z., Song, Y.*, & Wu, P., 2022. Robust geographical detector. International Journal of Applied Earth Observation and Geoinformation. 109, 102782.
DOI: 10.1016/j.jag.2022.102782.
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
